/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.common.config.UserdevConfigV2;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public abstract class PatcherExtension
extends MinecraftExtension {
    public static final String EXTENSION_NAME = "patcher";
    private boolean srgPatches = true;
    private boolean notchObf = false;
    private List<Object> extraExcs;
    private List<Object> extraMappings;
    @Nullable
    private UserdevConfigV2.DataFunction processor;

    public PatcherExtension(Project project) {
        super(project);
        ImmutableMap.builder().put((Object)(project.getName() + "_client"), (Object)"mcp.client.Start").put((Object)(project.getName() + "_server"), (Object)"net.minecraft.server.MinecraftServer").build().forEach((name, main) -> {
            RunConfig run = new RunConfig(project, (String)name);
            run.setTaskName((String)name);
            run.setMain((String)main);
            try {
                run.setWorkingDirectory(project.file((Object)"run").getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getRuns().add((Object)run);
        });
    }

    public abstract Property<Project> getParent();

    public abstract RegularFileProperty getCleanSrc();

    public abstract DirectoryProperty getPatchedSrc();

    public abstract DirectoryProperty getPatches();

    public abstract Property<String> getMcVersion();

    public boolean isSrgPatches() {
        return this.srgPatches;
    }

    public void setSrgPatches(boolean srgPatches) {
        this.srgPatches = srgPatches;
    }

    public boolean getNotchObf() {
        return this.notchObf;
    }

    public void setNotchObf(boolean value) {
        this.notchObf = value;
    }

    public abstract ConfigurableFileCollection getExcs();

    public void setExtraExcs(List<Object> extraExcs) {
        this.extraExcs = new ArrayList<Object>(extraExcs);
    }

    public void extraExcs(Object ... excs) {
        this.getExtraExcs().addAll(Arrays.asList(excs));
    }

    public void extraExc(Object exc) {
        this.extraExcs(exc);
    }

    public List<Object> getExtraExcs() {
        if (this.extraExcs == null) {
            this.extraExcs = new ArrayList<Object>();
        }
        return this.extraExcs;
    }

    public void extraMapping(Object mapping) {
        if (!(mapping instanceof String) && !(mapping instanceof File)) {
            throw new IllegalArgumentException("Extra mappings must be a file or a string!");
        }
        this.getExtraMappings().add(mapping);
    }

    public void setExtraMappings(List<Object> extraMappings) {
        this.extraMappings = new ArrayList<Object>(extraMappings);
    }

    public List<Object> getExtraMappings() {
        if (this.extraMappings == null) {
            this.extraMappings = new ArrayList<Object>();
        }
        return this.extraMappings;
    }

    @Nullable
    public UserdevConfigV2.DataFunction getProcessor() {
        return this.processor;
    }

    public abstract MapProperty<String, File> getProcessorData();

    public void setProcessor(Map<String, Object> map) {
        this.processor(map);
    }

    public void processor(Map<String, Object> map) {
        this.processor = new UserdevConfigV2.DataFunction();
        map.forEach((key, value) -> {
            if ("tool".equals(key)) {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("'tool' must be a string");
                }
                this.processor.setVersion((String)value);
                return;
            } else if ("args".equals(key)) {
                if (value instanceof String) {
                    this.processor.setArgs(Collections.singletonList((String)value));
                    return;
                } else if (value instanceof String[]) {
                    this.processor.setArgs(Arrays.asList((String[])value));
                    return;
                } else {
                    if (!(value instanceof Collection)) throw new IllegalArgumentException("'args' must be a String, or array of Strings");
                    this.processor.setArgs(new ArrayList<String>((Collection)value));
                }
                return;
            } else if ("repo".equals(key)) {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("'repo' must be a string");
                }
                this.processor.setRepo((String)value);
                return;
            } else {
                if (!"data".equals(key)) throw new IllegalArgumentException("Invalid processor key " + key);
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("'data' must be a map of string -> file");
                }
                this.getProcessorData().putAll((Map)value);
            }
        });
    }

    void copyFrom(PatcherExtension other) {
        this.getMappingChannel().set(other.getMappingChannel());
        this.getMappingVersion().set(other.getMappingVersion());
        this.getMcVersion().set(other.getMcVersion());
    }
}

