/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks.ide;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;

public abstract class CopyEclipseResources
extends Copy {
    public static final String NAME = "copyEclipseResources";

    public CopyEclipseResources() {
        this.getOutputs().upToDateWhen(task -> false);
    }

    public void configure(EclipseModel model, Project project) {
        this.setDestinationDir(new File((File)project.getLayout().getBuildDirectory().getAsFile().get(), this.getName()));
        Path destination = this.getDestinationDir().toPath();
        Map<SourceSet, SourceFolder> srcToOut = model.getClasspath().resolveDependencies().stream().filter(SourceFolder.class::isInstance).map(SourceFolder.class::cast).map(folder -> new SrcSetEntry(CopyEclipseResources.getSourceSetFromFolder(folder, project), (SourceFolder)folder)).filter(entry -> entry.srcSet != null).distinct().collect(Collectors.toMap(f -> f.srcSet, f -> f.source));
        srcToOut.forEach((src, out) -> {
            this.dependsOn(new Object[]{src.getProcessResourcesTaskName()});
            ProcessResources processResources = (ProcessResources)project.getTasks().named(src.getProcessResourcesTaskName(), ProcessResources.class).get();
            CopySpecInternal spec = this.getMainSpec().addChild();
            spec.into((Object)destination.relativize(project.file((Object)out.getOutput()).toPath()).toString());
            spec.with(new CopySpec[]{processResources.getRootSpec()});
            spec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        });
    }

    private static SourceSet getSourceSetFromFolder(SourceFolder folder, Project project) {
        Path in = project.file((Object)folder.getPath()).toPath();
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        for (SourceSet src : java.getSourceSets()) {
            if (!src.getResources().getSrcDirs().stream().map(File::toPath).anyMatch(path -> path.endsWith(in))) continue;
            return src;
        }
        return null;
    }

    private static final class SrcSetEntry {
        public final SourceSet srcSet;
        public final SourceFolder source;

        private SrcSetEntry(SourceSet srcSet, SourceFolder source) {
            this.srcSet = srcSet;
            this.source = source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SrcSetEntry that = (SrcSetEntry)o;
            return that.srcSet == this.srcSet;
        }

        public int hashCode() {
            return Objects.hash(this.srcSet);
        }
    }
}

