/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ApplyMappings
extends DefaultTask {
    private boolean javadocs = false;
    private boolean lambdas = true;

    public ApplyMappings() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(s -> s.file("output.zip")));
    }

    @TaskAction
    public void apply() throws IOException {
        McpNames names = McpNames.load(((RegularFile)this.getMappings().get()).getAsFile());
        try (ZipFile zin = new ZipFile(((RegularFile)this.getInput().get()).getAsFile());
             FileOutputStream fos = new FileOutputStream(((RegularFile)this.getOutput().get()).getAsFile());
             ZipOutputStream out = new ZipOutputStream(fos);){
            zin.stream().forEach(e -> {
                try {
                    out.putNextEntry(Utils.getStableEntry(e.getName()));
                    if (!e.getName().endsWith(".java")) {
                        IOUtils.copy((InputStream)zin.getInputStream((ZipEntry)e), (OutputStream)out);
                    } else {
                        out.write(names.rename(zin.getInputStream((ZipEntry)e), this.javadocs, this.lambdas).getBytes(StandardCharsets.UTF_8));
                    }
                    out.closeEntry();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            });
        }
    }

    @InputFile
    public abstract RegularFileProperty getInput();

    @InputFile
    public abstract RegularFileProperty getMappings();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Input
    public boolean getJavadocs() {
        return this.javadocs;
    }

    public void setJavadocs(boolean javadocs) {
        this.javadocs = javadocs;
    }

    @Input
    public boolean getLambdas() {
        return this.lambdas;
    }

    public void setLambdas(boolean lambdas) {
        this.lambdas = lambdas;
    }
}

