/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.mcp.ChannelProvider;
import net.minecraftforge.gradle.mcp.MCPChannelProvider;
import net.minecraftforge.gradle.mcp.OfficialChannelProvider;

public class ChannelProvidersExtension {
    public static final String EXTENSION_NAME = "channelProviders";
    private final Map<String, ChannelProvider> providers = new ConcurrentHashMap<String, ChannelProvider>();

    public ChannelProvidersExtension() {
        this.addProvider(new OfficialChannelProvider());
        this.addProvider(new MCPChannelProvider());
    }

    public Map<String, ChannelProvider> getProviderMap() {
        return Collections.unmodifiableMap(this.providers);
    }

    @Nullable
    public ChannelProvider getProvider(String channel) {
        return this.providers.get(channel);
    }

    public void addProvider(ChannelProvider provider) {
        for (String channel : provider.getChannels()) {
            ChannelProvider previous = this.providers.get(channel);
            if (previous != null) {
                throw new IllegalArgumentException(channel + " is already registered to " + previous + " containing channels " + previous.getChannels());
            }
            this.providers.put(channel, provider);
        }
    }
}

