/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class JavadocAdder {
    public static final String NEWLINE = System.getProperty("line.separator");

    private JavadocAdder() {
    }

    public static String buildJavadoc(String indent, String javadoc, boolean multiline) {
        StringBuilder builder = new StringBuilder();
        LinkedList list = Lists.newLinkedList();
        for (String line : Splitter.on((String)"\\n").splitToList((CharSequence)javadoc)) {
            list.addAll(JavadocAdder.wrapText(line, 120 - (indent.length() + 3)));
        }
        if (list.size() > 1 || multiline) {
            builder.append(indent);
            builder.append("/**");
            builder.append(NEWLINE);
            for (String line : list) {
                builder.append(indent);
                builder.append(" * ");
                builder.append(line);
                builder.append(NEWLINE);
            }
            builder.append(indent);
            builder.append(" */");
        } else {
            builder.append(indent);
            builder.append("/** ");
            builder.append(javadoc);
            builder.append(" */");
        }
        return builder.toString().replace(indent, indent);
    }

    private static List<String> wrapText(@Nullable String text, int len) {
        if (text == null) {
            return Lists.newArrayList();
        }
        if (len <= 0 || text.length() <= len) {
            return Lists.newArrayList((Object[])new String[]{text});
        }
        LinkedList lines = Lists.newLinkedList();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == ' ' || c == ',' || c == '-') {
                int tempNum;
                word.append(c);
                int n = tempNum = Character.isWhitespace(c) ? 1 : 0;
                if (line.length() + word.length() - tempNum > len) {
                    lines.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append((CharSequence)word);
                word.delete(0, word.length());
                continue;
            }
            word.append(c);
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines.stream().map(String::trim).collect(Collectors.toList());
    }
}

