/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.gradle.userdev.util.Deobfuscator;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;

public class DependencyRemapper {
    private final Project project;
    private Deobfuscator deobfuscator;
    private List<Consumer<String>> mappingListeners = new ArrayList<Consumer<String>>();

    public DependencyRemapper(Project project, Deobfuscator deobfuscator) {
        this.project = project;
        this.deobfuscator = deobfuscator;
    }

    public Dependency remap(Dependency dependency) {
        if (dependency instanceof ExternalModuleDependency) {
            return this.remapExternalModule((ExternalModuleDependency)dependency);
        }
        if (dependency instanceof FileCollectionDependency) {
            this.project.getLogger().warn("files(...) dependencies are not deobfuscated. Use a flatDir repository instead: https://docs.gradle.org/current/userguide/repository_types.html#sec:flat_dir_resolver");
        }
        this.project.getLogger().warn("Cannot deobfuscate dependency of type {}, using obfuscated version!", (Object)dependency.getClass().getSimpleName());
        return dependency;
    }

    private ExternalModuleDependency remapExternalModule(ExternalModuleDependency dependency) {
        ExternalModuleDependency newDep = dependency.copy();
        this.mappingListeners.add(m -> newDep.version(v -> v.strictly(newDep.getVersion() + "_mapped_" + m)));
        return newDep;
    }

    public void attachMappings(String mappings) {
        this.mappingListeners.forEach(l -> l.accept(mappings));
    }
}

