/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.DiffOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class TaskGeneratePatches
extends DefaultTask {
    private File base;
    private File modified;
    private File output;
    private ArchiveFormat outputFormat;
    private boolean autoHeader;
    private int contextLines = -1;
    private boolean verbose = false;
    private boolean printSummary = false;
    private String originalPrefix = "a/";
    private String modifiedPrefix = "b/";

    @TaskAction
    public void doTask() throws Exception {
        Path outputPath = this.getOutput().toPath();
        ArchiveFormat outputFormat = this.getOutputFormat();
        if (outputFormat == null) {
            outputFormat = ArchiveFormat.findFormat((Path)outputPath.getFileName());
        }
        this.getProject().getLogger().info("Base:" + this.getBase().toString());
        this.getProject().getLogger().info("Modified:" + this.getModified().toString());
        DiffOperation.Builder builder = DiffOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), LogLevel.LIFECYCLE)).aPath(this.getBase().toPath()).bPath(this.getModified().toPath()).outputPath(outputPath, outputFormat).autoHeader(this.isAutoHeader()).verbose(this.isVerbose()).summary(this.isPrintSummary()).aPrefix(this.originalPrefix).bPrefix(this.modifiedPrefix);
        int context = this.getContextLines();
        if (context != -1) {
            builder.context(context);
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
    }

    @InputFile
    public File getBase() {
        return this.base;
    }

    @InputFile
    public File getModified() {
        return this.modified;
    }

    @OutputDirectory
    public File getOutput() {
        return this.output;
    }

    @Input
    @Optional
    public ArchiveFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Input
    @Optional
    public boolean isAutoHeader() {
        return this.autoHeader;
    }

    @Input
    @Optional
    public int getContextLines() {
        return this.contextLines;
    }

    @Optional
    public boolean isVerbose() {
        return this.verbose;
    }

    @Optional
    public boolean isPrintSummary() {
        return this.printSummary;
    }

    @Input
    @Optional
    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    @Input
    @Optional
    public String getModifiedPrefix() {
        return this.modifiedPrefix;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void setModified(File modified) {
        this.modified = modified;
    }

    public void setOutput(File patches) {
        this.output = patches;
    }

    public void setOutputFormat(ArchiveFormat format) {
        this.outputFormat = format;
    }

    public void setAutoHeader(boolean autoHeader) {
        this.autoHeader = autoHeader;
    }

    public void setContextLines(int lines) {
        this.contextLines = lines;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public void setOriginalPrefix(String originalPrefix) {
        this.originalPrefix = originalPrefix;
    }

    public void setModifiedPrefix(String modifiedPrefix) {
        this.modifiedPrefix = modifiedPrefix;
    }
}

