/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskApplyPatches
extends DefaultTask {
    private File base;
    private File patches;
    private File output;
    private File rejects;
    private ArchiveFormat outputFormat;
    private ArchiveFormat rejectsFormat;
    private float minFuzzQuality = -1.0f;
    private int maxFuzzOffset = -1;
    private PatchMode patchMode = PatchMode.EXACT;
    private String patchesPrefix = "";
    private boolean verbose = false;
    private boolean printSummary = false;
    private boolean failOnError = true;
    private String originalPrefix = "a/";
    private String modifiedPrefix = "b/";

    @TaskAction
    public void doTask() throws Exception {
        if (this.patches == null) {
            FileUtils.copyFile((File)this.getBase(), (File)this.getOutput());
            return;
        }
        Path outputPath = this.getOutput().toPath();
        ArchiveFormat outputFormat = this.getOutputFormat();
        if (outputFormat == null) {
            outputFormat = ArchiveFormat.findFormat((Path)outputPath.getFileName());
        }
        Path rejectsPath = this.getRejects().toPath();
        ArchiveFormat rejectsFormat = this.getOutputFormat();
        if (rejectsFormat == null) {
            rejectsFormat = ArchiveFormat.findFormat((Path)rejectsPath.getFileName());
        }
        PatchOperation.Builder builder = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), LogLevel.LIFECYCLE)).basePath(this.getBase().toPath()).patchesPath(this.getPatches().toPath()).outputPath(outputPath, outputFormat).rejectsPath(rejectsPath, rejectsFormat).verbose(this.isVerbose()).summary(this.isPrintSummary()).mode(this.getPatchMode()).aPrefix(this.originalPrefix).bPrefix(this.modifiedPrefix).patchesPrefix(this.getPatchesPrefix());
        float minFuzz = this.getMinFuzzQuality();
        int maxOffset = this.getMaxFuzzOffset();
        if (minFuzz != -1.0f) {
            builder.minFuzz(minFuzz);
        }
        if (maxOffset != -1) {
            builder.maxOffset(maxOffset);
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
        if (exit != 0 && this.isFailOnError()) {
            throw new RuntimeException("Patches failed to apply.");
        }
    }

    @Input
    public File getBase() {
        return this.base;
    }

    @InputDirectory
    @Optional
    public File getPatches() {
        return this.patches;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    @Optional
    public File getRejects() {
        return this.rejects;
    }

    @Input
    @Optional
    public ArchiveFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Input
    @Optional
    public ArchiveFormat getRejectsFormat() {
        return this.rejectsFormat;
    }

    @Input
    @Optional
    public float getMinFuzzQuality() {
        return this.minFuzzQuality;
    }

    @Input
    @Optional
    public int getMaxFuzzOffset() {
        return this.maxFuzzOffset;
    }

    @Input
    @Optional
    public PatchMode getPatchMode() {
        return this.patchMode;
    }

    @Input
    @Optional
    public String getPatchesPrefix() {
        return this.patchesPrefix;
    }

    @Optional
    public boolean isVerbose() {
        return this.verbose;
    }

    @Optional
    public boolean isPrintSummary() {
        return this.printSummary;
    }

    @Input
    @Optional
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Input
    @Optional
    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    @Input
    @Optional
    public String getModifiedPrefix() {
        return this.modifiedPrefix;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void setPatches(File patches) {
        this.patches = patches;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setRejects(File rejects) {
        this.rejects = rejects;
    }

    public void setOutputFormat(ArchiveFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setRejectsFormat(ArchiveFormat rejectsFormat) {
        this.rejectsFormat = rejectsFormat;
    }

    public void setMinFuzzQuality(float minFuzzQuality) {
        this.minFuzzQuality = minFuzzQuality;
    }

    public void setMaxFuzzOffset(int maxFuzzOffset) {
        this.maxFuzzOffset = maxFuzzOffset;
    }

    public void setPatchMode(PatchMode patchMode) {
        this.patchMode = patchMode;
    }

    public void setPatchesPrefix(String patchesPrefix) {
        this.patchesPrefix = patchesPrefix;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setOriginalPrefix(String originalPrefix) {
        this.originalPrefix = originalPrefix;
    }

    public void setModifiedPrefix(String modifiedPrefix) {
        this.modifiedPrefix = modifiedPrefix;
    }
}

