/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class CreateFakeSASPatches
extends DefaultTask {
    private List<Supplier<File>> files = new ArrayList<Supplier<File>>();
    private Supplier<File> output = () -> this.getProject().file((Object)("build/" + this.getName() + "/patches/"));

    @InputFiles
    public List<File> getFiles() {
        return this.files.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public void addFile(File value) {
        this.addFile(() -> value);
    }

    public void addFile(Supplier<File> value) {
        this.files.add(value);
    }

    @OutputDirectory
    public File getOutput() {
        return this.output.get();
    }

    public void setOutput(File value) {
        this.setOutput(() -> value);
    }

    public void setOutput(Supplier<File> value) {
        this.output = value;
    }

    @TaskAction
    public void apply() throws IOException {
        if (this.getOutput().exists()) {
            this.getOutput().mkdirs();
        }
        for (File file : this.getFiles()) {
            for (String line : FileUtils.readLines((File)file)) {
                int idx = line.indexOf(35);
                if (idx == 0 || line.isEmpty()) continue;
                if (idx != -1) {
                    line = line.substring(0, idx - 1);
                }
                if (line.charAt(0) == '\t') {
                    line = line.substring(1);
                }
                String cls = (line.trim() + "    ").split(" ", -1)[0];
                File patch = new File(this.getOutput(), cls + ".java.patch");
                if (!patch.getParentFile().exists()) {
                    patch.getParentFile().mkdirs();
                }
                patch.createNewFile();
            }
        }
    }
}

