/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExtractMCPData
extends DefaultTask {
    private static final Gson GSON = new GsonBuilder().create();
    private String key = "mappings";
    private Supplier<File> configSupplier;
    private File config;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.srg"));

    @TaskAction
    public void run() throws IOException {
        block29: {
            try (ZipFile zip = new ZipFile(this.getConfig());){
                ZipEntry entry = zip.getEntry("config.json");
                if (entry == null) {
                    throw new IllegalStateException("Could not find 'config.json' in " + this.getConfig().getAbsolutePath());
                }
                int spec = Config.getSpec(zip.getInputStream(entry));
                if (spec == 1) {
                    MCPConfigV1 cfg = (MCPConfigV1)GSON.fromJson((Reader)new InputStreamReader(zip.getInputStream(entry)), MCPConfigV1.class);
                    String path = cfg.getData(this.key.split("/"));
                    if (path == null && "statics".equals(this.key)) {
                        path = "config/static_methods.txt";
                    }
                    if (path == null) {
                        throw new IllegalStateException("Could not find data entry for '" + this.key + "'");
                    }
                    entry = zip.getEntry(path);
                    if (entry == null) {
                        throw new IllegalStateException("Invalid config zip, Missing path '" + path + "'");
                    }
                    try (FileOutputStream out = new FileOutputStream(this.getOutput());){
                        IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
                        break block29;
                    }
                }
                throw new IllegalStateException("Unsupported spec version '" + spec + "'");
            }
        }
    }

    @InputFile
    public File getConfig() {
        if (this.config == null && this.configSupplier != null) {
            this.config = this.configSupplier.get();
        }
        return this.config;
    }

    public void setConfig(File value) {
        this.config = value;
        this.configSupplier = null;
    }

    public void setConfig(Supplier<File> valueSupplier) {
        this.configSupplier = valueSupplier;
        this.config = null;
    }

    @Input
    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

