/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.diff;

import net.minecraftforge.gradle.common.diff.ContextualPatch;

public class PatchUtils {
    static boolean similar(ContextualPatch patch, String target, String hunk, char lineType) {
        if (patch.c14nAccess) {
            if (patch.c14nWhitespace) {
                target = target.replaceAll("[\t| ]+", " ");
                hunk = hunk.replaceAll("[\t| ]+", " ");
            }
            String[] t = target.split(" ");
            String[] h = hunk.split(" ");
            int targetIndex = 0;
            int hunkIndex = 0;
            while (targetIndex < t.length && hunkIndex < h.length) {
                boolean labels;
                boolean isTargetAccess = PatchUtils.isAccess(t[targetIndex]);
                boolean isHunkAccess = PatchUtils.isAccess(h[hunkIndex]);
                if (isTargetAccess || isHunkAccess) {
                    if (isTargetAccess) {
                        ++targetIndex;
                    }
                    if (!isHunkAccess) continue;
                    ++hunkIndex;
                    continue;
                }
                String hunkPart = h[hunkIndex];
                String targetPart = t[targetIndex];
                boolean bl = labels = PatchUtils.isLabel(targetPart) && PatchUtils.isLabel(hunkPart);
                if (!labels && !targetPart.equals(hunkPart)) {
                    return false;
                }
                ++hunkIndex;
                ++targetIndex;
            }
            return h.length == hunkIndex && t.length == targetIndex;
        }
        if (patch.c14nWhitespace) {
            return target.replaceAll("[\t| ]+", " ").equals(hunk.replaceAll("[\t| ]+", " "));
        }
        return target.equals(hunk);
    }

    static boolean isAccess(String data) {
        return data.equalsIgnoreCase("public") || data.equalsIgnoreCase("private") || data.equalsIgnoreCase("protected") || data.equalsIgnoreCase("final");
    }

    static boolean isLabel(String data) {
        return data.startsWith("label");
    }
}

