/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.task.JarExec;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ApplyMCPFunction
extends JarExec {
    private static final Pattern REPLACE_PATTERN = Pattern.compile("^\\{(\\w+)\\}$");
    private File input;
    private File output;
    private File mcp;
    private String functionName;
    private Map<String, String> replacements = new HashMap<String, String>();

    @Override
    @TaskAction
    public void apply() throws IOException {
        byte[] cfg_data = Utils.getZipData(this.getMCP(), "config.json");
        int spec = Config.getSpec(cfg_data);
        if (spec != 1) {
            throw new IllegalStateException("Could not load MCP config, Unknown Spec: " + spec + " File: " + this.getMCP());
        }
        MCPConfigV1 config = MCPConfigV1.get(cfg_data);
        MCPConfigV1.Function function = config.getFunction(this.functionName);
        this.tool = function.getVersion();
        this.args = function.getArgs().toArray(new String[0]);
        try (ZipFile zip = new ZipFile(this.getMCP());){
            function.getArgs().forEach(arg -> {
                String argName;
                Matcher matcher = REPLACE_PATTERN.matcher((CharSequence)arg);
                String string = argName = matcher.find() ? matcher.group(1) : null;
                if (argName == null) {
                    return;
                }
                if (argName.equals("input")) {
                    this.replacements.put((String)arg, this.getInput().getAbsolutePath());
                } else if (argName.equals("output")) {
                    this.replacements.put((String)arg, this.getOutput().getAbsolutePath());
                } else if (argName.equals("log")) {
                    this.replacements.put((String)arg, this.getOutput().getAbsolutePath() + ".log");
                } else {
                    Object referencedData = config.getData().get(argName);
                    if (referencedData instanceof String) {
                        ZipEntry entry = zip.getEntry((String)referencedData);
                        if (entry == null) {
                            return;
                        }
                        String entryName = entry.getName();
                        try {
                            File data = this.makeFile(entry.getName());
                            if (entry.isDirectory()) {
                                Utils.extractDirectory(this::makeFile, zip, entryName);
                            } else {
                                Utils.extractFile(zip, entry, data);
                            }
                            this.replacements.put((String)arg, data.getAbsolutePath());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        super.apply();
    }

    @Override
    protected List<String> filterArgs() {
        return Arrays.stream(this.getArgs()).map(arg -> this.replacements.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }

    @InputFile
    public File getMCP() {
        return this.mcp;
    }

    public void setMCP(File value) {
        this.mcp = value;
    }

    @OutputFile
    public File getOutput() {
        if (this.output == null) {
            this.setOutput(this.getProject().file((Object)("build/" + this.getName() + "/output.jar")));
        }
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    private File makeFile(String name) {
        return new File(this.getOutput().getParent(), name);
    }
}

