/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.cloudbees.diff.PatchException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.diff.ContextualPatch;
import net.minecraftforge.gradle.common.diff.HunkReport;
import net.minecraftforge.gradle.common.diff.PatchFile;
import net.minecraftforge.gradle.common.diff.ZipContext;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskApplyPatches
extends DefaultTask {
    private File clean;
    private File patches;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.zip"));
    private File rejects = this.getProject().file((Object)("build/" + this.getName() + "/rejects.zip"));
    private int maxFuzz = 0;
    private boolean canonicalizeAccess = true;
    private boolean canonicalizeWhitespace = true;
    private boolean failOnErrors = true;
    private String originalPrefix;
    private String modifiedPrefix;

    @TaskAction
    public void applyPatches() {
        block19: {
            try (ZipFile zip = new ZipFile(this.getClean());){
                ZipContext context = new ZipContext(zip);
                if (this.getPatches() == null) {
                    context.save(this.getOutput());
                    return;
                }
                boolean all_success = Files.walk(this.getPatches().toPath(), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".patch")).map(p -> {
                    boolean success = true;
                    ContextualPatch patch = ContextualPatch.create(PatchFile.from(p.toFile()), context, this.getOriginalPrefix(), this.getModifiedPrefix());
                    patch.setCanonialization(this.getCanonicalizeAccess(), this.getCanonicalizeWhitespace());
                    patch.setMaxFuzz(this.getMaxFuzz());
                    String name = p.toFile().getAbsolutePath().substring(this.getPatches().getAbsolutePath().length() + 1);
                    try {
                        this.getLogger().info("Apply Patch: " + name);
                        List<ContextualPatch.PatchReport> result = patch.patch(false);
                        for (int x = 0; x < result.size(); ++x) {
                            ContextualPatch.PatchReport report = result.get(x);
                            if (report.getStatus().isSuccess()) continue;
                            this.getLogger().error("  Apply Patch: " + name);
                            success = false;
                            for (int y = 0; y < report.hunkReports().size(); ++y) {
                                HunkReport hunk = report.hunkReports().get(y);
                                if (!hunk.hasFailed()) continue;
                                if (hunk.failure == null) {
                                    this.getLogger().error("    Hunk #" + hunk.hunkID + " Failed @" + hunk.index + " Fuzz: " + hunk.fuzz);
                                    continue;
                                }
                                this.getLogger().error("    Hunk #" + hunk.hunkID + " Failed: " + hunk.failure.getMessage());
                            }
                        }
                    }
                    catch (PatchException e) {
                        this.getLogger().error("  Apply Patch: " + name);
                        this.getLogger().error("    " + e.getMessage());
                    }
                    catch (IOException e) {
                        this.getLogger().error("  Apply Patch: " + name);
                        throw new RuntimeException(e);
                    }
                    return success;
                }).reduce(true, (a, b) -> a != false && b != false);
                if (all_success || !this.failOnErrors) {
                    context.save(this.getOutput());
                    this.saveRejects(context);
                    break block19;
                }
                this.saveRejects(context);
                throw new RuntimeException("Failed to apply patches. See log for details.");
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private void saveRejects(ZipContext context) throws IOException {
        File rejectsFile = this.getRejects();
        if (!(rejectsFile.getName().endsWith(".zip") || rejectsFile.getName().endsWith(".jar") || rejectsFile.isFile())) {
            File tmp = new File(this.getTemporaryDir(), "rejects_tmp.zip");
            context.saveRejects(tmp);
            this.getProject().copy(spec -> {
                spec.from(new Object[]{this.getProject().zipTree((Object)tmp)});
                spec.into((Object)rejectsFile);
            });
        } else {
            context.saveRejects(rejectsFile);
        }
    }

    @InputFile
    public File getClean() {
        return this.clean;
    }

    @Optional
    @InputDirectory
    public File getPatches() {
        return this.patches;
    }

    @Input
    public int getMaxFuzz() {
        return this.maxFuzz;
    }

    @Input
    public boolean getCanonicalizeWhitespace() {
        return this.canonicalizeWhitespace;
    }

    @Input
    public boolean getCanonicalizeAccess() {
        return this.canonicalizeAccess;
    }

    @Input
    @Optional
    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    @Input
    @Optional
    public String getModifiedPrefix() {
        return this.modifiedPrefix;
    }

    public boolean getFailOnErrors() {
        return this.failOnErrors;
    }

    public void setFailOnErrors(boolean value) {
        this.failOnErrors = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    @OutputFile
    public File getRejects() {
        return this.rejects;
    }

    public void setClean(File clean) {
        this.clean = clean;
    }

    public void setPatches(File value) {
        this.patches = value;
    }

    public void setMaxFuzz(int value) {
        this.maxFuzz = value;
    }

    public void setCanonicalizeWhitespace(boolean value) {
        this.canonicalizeWhitespace = value;
    }

    public void setCanonicalizeAccess(boolean value) {
        this.canonicalizeAccess = value;
    }

    public void setOriginalPrefix(String value) {
        this.originalPrefix = value;
    }

    public void setModifiedPrefix(String value) {
        this.modifiedPrefix = value;
    }

    public void setOutput(File value) {
        this.output = value;
    }

    public void setRejects(File rejects) {
        this.rejects = rejects;
    }
}

