/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class IntellijRunGenerator
extends RunConfigGenerator.XMLConfigurationBuilder {
    boolean useGradlePaths = true;

    public IntellijRunGenerator(@Nonnull Project project) {
        this.detectGradleDelegation(project);
    }

    private void detectGradleDelegation(Project project) {
        IdeaModel idea;
        File ideaFileProject;
        File ideaWorkspace;
        XPath xpath = XPathFactory.newInstance().newXPath();
        File ideaGradleSettings = project.file((Object)".idea/gradle.xml");
        if (ideaGradleSettings.exists() && ideaGradleSettings.isFile()) {
            try {
                Node value = (Node)xpath.evaluate("/project/component[@name='GradleSettings']/option[@name='linkedExternalProjectsSettings']/GradleProjectSettings/option[@name='delegatedBuild']/@value", new InputSource(new FileInputStream(ideaGradleSettings)), XPathConstants.NODE);
                if (value != null) {
                    this.useGradlePaths = Boolean.parseBoolean(value.getTextContent());
                    return;
                }
            }
            catch (IOException | XPathExpressionException e) {
                e.printStackTrace();
            }
        }
        if ((ideaWorkspace = project.file((Object)".idea/workspace.xml")).exists() && ideaWorkspace.isFile()) {
            try {
                Node value = (Node)xpath.evaluate("/project/component[@name='DefaultGradleProjectSettings']/option[@name='delegatedBuild']/@value", new InputSource(new FileInputStream(ideaWorkspace)), XPathConstants.NODE);
                if (value != null) {
                    this.useGradlePaths = Boolean.parseBoolean(value.getTextContent());
                    return;
                }
            }
            catch (IOException | XPathExpressionException e) {
                e.printStackTrace();
            }
        }
        if ((ideaFileProject = project.file((idea = (IdeaModel)project.getExtensions().findByType(IdeaModel.class)) != null ? idea.getProject().getOutputFile() : project.getName() + ".ipr")).exists() && ideaFileProject.isFile()) {
            try {
                Node value = (Node)xpath.evaluate("/project/component[@name='GradleSettings']/option[@name='linkedExternalProjectsSettings']/GradleProjectSettings/option[@name='delegatedBuild']/@value", new InputSource(new FileInputStream(ideaFileProject)), XPathConstants.NODE);
                if (value != null) {
                    this.useGradlePaths = Boolean.parseBoolean(value.getTextContent());
                    return;
                }
            }
            catch (IOException | XPathExpressionException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @Nonnull
    protected Map<String, Document> createRunConfiguration(@Nonnull Project project, @Nonnull RunConfig runConfig, @Nonnull DocumentBuilder documentBuilder, List<String> additionalClientArgs) {
        LinkedHashMap<String, Document> documents = new LinkedHashMap<String, Document>();
        Map<String, String> updatedTokens = IntellijRunGenerator.configureTokens(runConfig, this.useGradlePaths ? IntellijRunGenerator.mapModClassesToGradle(project, runConfig) : IntellijRunGenerator.mapModClassesToIdea(project, runConfig));
        Document javaDocument = documentBuilder.newDocument();
        Element rootElement = javaDocument.createElement("component");
        Element configuration = javaDocument.createElement("configuration");
        configuration.setAttribute("default", "false");
        configuration.setAttribute("name", runConfig.getUniqueName());
        configuration.setAttribute("type", "Application");
        configuration.setAttribute("factoryName", "Application");
        configuration.setAttribute("singleton", runConfig.isSingleInstance() ? "true" : "false");
        IntellijRunGenerator.elementOption(javaDocument, configuration, "MAIN_CLASS_NAME", runConfig.getMain());
        IntellijRunGenerator.elementOption(javaDocument, configuration, "VM_PARAMETERS", IntellijRunGenerator.getJvmArgs(runConfig, additionalClientArgs, updatedTokens));
        IntellijRunGenerator.elementOption(javaDocument, configuration, "PROGRAM_PARAMETERS", IntellijRunGenerator.getArgs(runConfig, updatedTokens));
        IntellijRunGenerator.elementOption(javaDocument, configuration, "WORKING_DIRECTORY", IntellijRunGenerator.replaceRootDirBy(project, runConfig.getWorkingDirectory(), "$PROJECT_DIR$"));
        Element module = javaDocument.createElement("module");
        module.setAttribute("name", runConfig.getIdeaModule());
        configuration.appendChild(module);
        Element envs = javaDocument.createElement("envs");
        runConfig.getEnvironment().forEach((name, value) -> {
            Element envEntry = javaDocument.createElement("env");
            envEntry.setAttribute("name", (String)name);
            envEntry.setAttribute("value", IntellijRunGenerator.replaceRootDirBy(project, runConfig.replace(updatedTokens, (String)value), "$PROJECT_DIR$"));
            envs.appendChild(envEntry);
        });
        configuration.appendChild(envs);
        Element methods = javaDocument.createElement("method");
        methods.setAttribute("v", "2");
        Element makeTask = javaDocument.createElement("option");
        makeTask.setAttribute("name", "Make");
        makeTask.setAttribute("enabled", "true");
        methods.appendChild(makeTask);
        Element gradleTask = javaDocument.createElement("option");
        gradleTask.setAttribute("name", "Gradle.BeforeRunTask");
        gradleTask.setAttribute("enabled", "true");
        gradleTask.setAttribute("tasks", project.getTasks().getByName("prepare" + Utils.capitalize(runConfig.getTaskName())).getPath());
        gradleTask.setAttribute("externalProjectPath", "$PROJECT_DIR$");
        methods.appendChild(gradleTask);
        configuration.appendChild(methods);
        rootElement.appendChild(configuration);
        javaDocument.appendChild(rootElement);
        documents.put(runConfig.getUniqueFileName() + ".xml", javaDocument);
        return documents;
    }

    private static Stream<String> mapModClassesToIdea(@Nonnull Project project, @Nonnull RunConfig runConfig) {
        IdeaModel idea = (IdeaModel)project.getExtensions().findByType(IdeaModel.class);
        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSetContainer sourceSets = javaPlugin.getSourceSets();
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        if (runConfig.getMods().isEmpty()) {
            return IntellijRunGenerator.getIdeaPathsForSourceset(project, idea, "production", null);
        }
        return runConfig.getMods().stream().map(modConfig -> modConfig.getSources().stream().flatMap(source -> {
            String outName = source == main ? "production" : source.getName();
            return IntellijRunGenerator.getIdeaPathsForSourceset(project, idea, outName, modConfig.getName());
        })).flatMap(Function.identity());
    }

    private static Stream<String> getIdeaPathsForSourceset(@Nonnull Project project, @Nullable IdeaModel idea, String outName, @Nullable String modName) {
        String ideaClasses;
        String ideaResources;
        try {
            String outputPath = idea != null ? idea.getProject().getPathFactory().path("$PROJECT_DIR$").getCanonicalUrl() : project.getProjectDir().getCanonicalPath();
            ideaResources = Paths.get(outputPath, "out", outName, "resources").toFile().getCanonicalPath();
            ideaClasses = Paths.get(outputPath, "out", outName, "classes").toFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting paths for idea run configs", e);
        }
        if (modName != null) {
            ideaResources = modName + "%%" + ideaResources;
            ideaClasses = modName + "%%" + ideaClasses;
        }
        return Stream.of(ideaResources, ideaClasses);
    }
}

