/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.gradle.GradleRepositoryAdapter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import groovy.util.Node;
import groovy.util.XmlParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.xml.sax.SAXException;

public class MavenArtifactDownloader {
    private static final Cache<String, File> CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Map<Project, Integer> COUNTER = new HashMap<Project, Integer>();
    private static final Map<String, String> VERSIONS = new HashMap<String, String>();

    public static File download(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, true, true, true);
    }

    public static String getVersion(Project project, String artifact) {
        Artifact art = Artifact.from(artifact);
        if (!art.getVersion().endsWith("+") && !art.isSnapshot()) {
            return art.getVersion();
        }
        MavenArtifactDownloader._download(project, artifact, true, false, true, true);
        return VERSIONS.get(artifact);
    }

    public static File gradle(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, false, true, true);
    }

    public static File generate(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, true, false, true);
    }

    public static File manual(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, false, false, true);
    }

    private static File _download(Project project, String artifact, boolean changing, boolean generated, boolean gradle, boolean manual) {
        Artifact art = Artifact.from(artifact);
        File ret = null;
        try {
            ret = (File)CACHE.getIfPresent((Object)artifact);
            if (ret != null && !ret.exists()) {
                CACHE.invalidate((Object)artifact);
                ret = null;
            }
            ArrayList<MavenArtifactRepository> mavens = new ArrayList<MavenArtifactRepository>();
            ArrayList<GradleRepositoryAdapter> fakes = new ArrayList<GradleRepositoryAdapter>();
            ArrayList<ArtifactRepository> others = new ArrayList<ArtifactRepository>();
            project.getRepositories().forEach(repo -> {
                if (repo instanceof MavenArtifactRepository) {
                    mavens.add((MavenArtifactRepository)repo);
                } else if (repo instanceof GradleRepositoryAdapter) {
                    fakes.add((GradleRepositoryAdapter)repo);
                } else {
                    others.add((ArtifactRepository)repo);
                }
            });
            if (ret == null && generated) {
                ret = MavenArtifactDownloader._generate(fakes, art);
            }
            if (ret == null && manual) {
                ret = MavenArtifactDownloader._manual(project, mavens, art, changing);
            }
            if (ret == null && gradle) {
                ret = MavenArtifactDownloader._gradle(project, others, art, changing);
            }
            if (ret != null) {
                CACHE.put((Object)artifact, (Object)ret);
            }
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static File _generate(List<GradleRepositoryAdapter> repos, Artifact artifact) {
        for (GradleRepositoryAdapter repo : repos) {
            File ret = repo.getArtifact((ArtifactIdentifier)artifact);
            if (ret == null || !ret.exists()) continue;
            return ret;
        }
        return null;
    }

    private static File _manual(Project project, List<MavenArtifactRepository> repos, Artifact artifact, boolean changing) throws IOException, URISyntaxException {
        if (!artifact.getVersion().endsWith("+") && !artifact.isSnapshot()) {
            for (MavenArtifactRepository repo : repos) {
                Pair<Artifact, File> pair = MavenArtifactDownloader._manualMaven(project, repo.getUrl(), artifact, changing);
                if (pair == null || !((File)pair.getValue()).exists()) continue;
                return (File)pair.getValue();
            }
            return null;
        }
        ArrayList<Pair<Artifact, File>> versions = new ArrayList<Pair<Artifact, File>>();
        for (MavenArtifactRepository repo : repos) {
            Pair<Artifact, File> pair = MavenArtifactDownloader._manualMaven(project, repo.getUrl(), artifact, changing);
            if (pair == null || !((File)pair.getValue()).exists()) continue;
            versions.add(pair);
        }
        Artifact version = null;
        File ret = null;
        for (Pair pair : versions) {
            if (version != null && version.compareTo((Artifact)pair.getKey()) >= 0) continue;
            version = (Artifact)pair.getKey();
            ret = (File)pair.getValue();
        }
        if (ret == null) {
            return null;
        }
        VERSIONS.put(artifact.getDescriptor(), version.getVersion());
        return ret;
    }

    private static Pair<Artifact, File> _manualMaven(Project project, URI maven, Artifact artifact, boolean changing) throws IOException, URISyntaxException {
        File ret;
        if (artifact.getVersion().endsWith("+")) {
            File meta = MavenArtifactDownloader._downloadWithCache(project, maven, artifact.getGroup().replace('.', '/') + '/' + artifact.getName() + "/maven-metadata.xml", true, true);
            if (meta == null) {
                return null;
            }
            try {
                DefaultArtifactVersion minVersion;
                List versions;
                Node xml = new XmlParser().parse(meta);
                Node versioning = MavenArtifactDownloader.getPath(xml, "versioning/versions");
                List list = versions = versioning == null ? null : (List)versioning.get("version");
                if (versions == null) {
                    meta.delete();
                    throw new IOException("Invalid maven-metadata.xml file, missing version list");
                }
                String prefix = artifact.getVersion().substring(0, artifact.getVersion().length() - 1);
                DefaultArtifactVersion defaultArtifactVersion = minVersion = !prefix.endsWith(".") && prefix.length() > 0 ? new DefaultArtifactVersion(prefix) : null;
                if (minVersion != null) {
                    int idx = prefix.lastIndexOf(46);
                    prefix = idx == -1 ? "" : prefix.substring(0, idx + 1);
                }
                String prefix_ = prefix;
                ArtifactVersion highest = versions.stream().map(Node::text).filter(s -> s.startsWith(prefix_)).map(DefaultArtifactVersion::new).filter(arg_0 -> MavenArtifactDownloader.lambda$_manualMaven$2((ArtifactVersion)minVersion, arg_0)).sorted().reduce((first, second) -> second).orElse(null);
                if (highest == null) {
                    return null;
                }
                artifact = Artifact.from(artifact.getGroup(), artifact.getName(), highest.toString(), artifact.getClassifier(), artifact.getExtension());
            }
            catch (ParserConfigurationException | SAXException e) {
                meta.delete();
                throw new IOException("Invalid maven-metadata.xml file", e);
            }
        } else if (artifact.getVersion().contains("-SNAPSHOT")) {
            return null;
        }
        return (ret = MavenArtifactDownloader._downloadWithCache(project, maven, artifact.getPath(), changing, false)) == null ? null : ImmutablePair.of((Object)artifact, (Object)ret);
    }

    private static Node getPath(Node node, String path) {
        Node tmp = node;
        for (String pt : path.split("/")) {
            if ((tmp = (Node)((List)tmp.get(pt)).stream().findFirst().orElse(null)) != null) continue;
            return null;
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File _gradle(Project project, List<ArtifactRepository> repos, Artifact mine, boolean changing) {
        String name = "mavenDownloader_" + mine.getDescriptor().replace(':', '_');
        Project project2 = project;
        synchronized (project2) {
            int count = COUNTER.getOrDefault(project, 1);
            name = name + "_" + count++;
            COUNTER.put(project, count);
        }
        ArrayList old = new ArrayList(project.getRepositories());
        project.getRepositories().clear();
        project.getRepositories().addAll(repos);
        Configuration cfg = (Configuration)project.getConfigurations().create(name);
        ExternalModuleDependency dependency = (ExternalModuleDependency)project.getDependencies().create((Object)mine.getDescriptor());
        dependency.setChanging(changing);
        cfg.getDependencies().add((Object)dependency);
        cfg.resolutionStrategy(strat -> {
            strat.cacheChangingModulesFor(5, TimeUnit.MINUTES);
            strat.cacheDynamicVersionsFor(5, TimeUnit.MINUTES);
        });
        Set files = null;
        try {
            files = cfg.resolve();
        }
        catch (NullPointerException npe) {
            project.getLogger().error("Failed to download " + mine.getDescriptor() + " gradle exploded");
            return null;
        }
        File ret = (File)files.iterator().next();
        cfg.getResolvedConfiguration().getResolvedArtifacts().forEach(art -> {
            ModuleVersionIdentifier resolved = art.getModuleVersion().getId();
            if (resolved.getGroup().equals(mine.getGroup()) && resolved.getName().equals(mine.getName()) && (mine.getClassifier() == null && art.getClassifier() == null || mine.getClassifier().equals(art.getClassifier()))) {
                VERSIONS.put(mine.getDescriptor(), resolved.getVersion());
            }
        });
        project.getConfigurations().remove((Object)cfg);
        project.getRepositories().clear();
        project.getRepositories().addAll(old);
        return ret;
    }

    private static File _downloadWithCache(Project project, URI maven, String path, boolean changing, boolean bypassLocal) throws IOException, URISyntaxException {
        URL url = new URIBuilder(maven).setPath(maven.getPath() + '/' + path).build().normalize().toURL();
        File target = Utils.getCache(project, "maven_downloader", path);
        return Utils.downloadWithCache(url, target, changing, bypassLocal);
    }

    private static /* synthetic */ boolean lambda$_manualMaven$2(ArtifactVersion minVersion, DefaultArtifactVersion v) {
        return minVersion == null || minVersion.compareTo((Object)v) <= 0;
    }
}

