/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.DownloadTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forgeBin-{API_VERSION}.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forgeBin-{API_VERSION}.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-srg.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forge-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "repackForge"});
    }

    @Override
    public void afterEvaluate() {
        String apiVersion = ((UserExtension)this.getExtension()).getApiVersion();
        int buildNumber = Integer.parseInt(apiVersion.substring(apiVersion.lastIndexOf(46) + 1));
        if (buildNumber < 967 || buildNumber > 1047) {
            throw new IllegalArgumentException("ForgeGradle 1.1 only works for Forge versions 10.12.0.967 - 10.12.0.1047");
        }
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)("net.minecraftforge:forge:" + apiVersion + ":userdev@jar"));
        super.afterEvaluate();
        ProcessJarTask deobf = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        boolean clean = deobf.isClean();
        DownloadTask dl = this.makeTask("getJavadocs", DownloadTask.class);
        dl.setUrl(this.delayedString("http://files.minecraftforge.net/maven/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-javadoc.zip"));
        dl.setOutput(this.delayedFile((clean ? this.getCacheDir() : "{BUILD_DIR}/dirtyArtifacts") + "/forgeBin-{API_VERSION}-javadoc.jar"));
        deobf.dependsOn(new Object[]{dl});
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar");
    }

    @Override
    protected String getDecompOut() {
        return "/forge-{API_VERSION}-decomp.jar";
    }

    @Override
    protected String getCacheDir() {
        return "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}";
    }

    @Override
    protected void createMcModuleDep(boolean isClean, DependencyHandler depHandler, String depConfig, boolean remove) {
        if (!remove) {
            final String repoDir = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts").call().getAbsolutePath();
            this.project.allprojects((Action)new Action<Project>(){

                public void execute(Project proj) {
                    ForgeUserPlugin.this.addFlatRepo(proj, "forgeFlatRepo", repoDir);
                    proj.getLogger().info("Adding repo to " + proj.getPath() + " >> " + repoDir);
                }
            });
        }
        if (((UserExtension)this.getExtension()).isDecomp) {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"forgeSrc", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
            if (remove) {
                System.out.println("removing forgeBin");
                this.project.getConfigurations().getByName(depConfig).exclude((Map)ImmutableMap.of((Object)"module", (Object)"forgeBin"));
            }
        } else {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"forgeBin", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
            if (remove) {
                System.out.println("removing forgeSrc");
                this.project.getConfigurations().getByName(depConfig).exclude((Map)ImmutableMap.of((Object)"module", (Object)"forgeSrc"));
            }
        }
    }

    @Override
    public void finalCall() {
        super.finalCall();
        if (((UserExtension)this.getExtension()).isDecomp) {
            boolean isClean = ((ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar")).isClean();
            ((ReobfTask)this.project.getTasks().getByName("reobf")).setRecompFile(this.delayedFile((isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts") + "/forgeSrc-{API_VERSION}.jar"));
        }
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        String prefix = isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        DelayedFile fmled = this.delayedFile(prefix + "/forge-{API_VERSION}-fmled.jar");
        final DelayedFile fmlInjected = this.delayedFile(prefix + "/forge-{API_VERSION}-fmlinjected.jar");
        DelayedFile remapped = this.delayedFile(prefix + "/forge-{API_VERSION}-mcped.jar");
        DelayedFile forged = this.delayedFile(prefix + "/forge-{API_VERSION}-src-nojd.jar");
        DelayedFile forgeJavaDocced = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}-sources.jar");
        final DelayedFile forgeRecomp = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}.jar");
        DelayedFile recompSrc = this.delayedFile("{BUILD_DIR}/tmp/recompSrc");
        DelayedFile recompCls = this.delayedFile("{BUILD_DIR}/tmp/recompCls");
        Spec onlyIfCheck = new Spec(){

            public boolean isSatisfiedBy(Object obj) {
                boolean didWork = ((Task)obj).dependsOnTaskDidWork();
                boolean exists = forgeRecomp.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        };
        final PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        Zip inject = this.makeTask("addFmlSources", Zip.class);
        inject.dependsOn(new Object[]{fmlPatches});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        inject.onlyIf(new Spec(){

            public boolean isSatisfiedBy(Object o) {
                boolean didWork = fmlPatches.getDidWork();
                boolean exists = fmlInjected.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        });
        File injectFile = fmlInjected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.dependsOn(new Object[]{inject});
        remap.setInJar(fmlInjected);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        remap.setDoesJavadocs(false);
        PatchJarTask forgePatches = this.makeTask("doForgePatches", PatchJarTask.class);
        forgePatches.dependsOn(new Object[]{remap});
        forgePatches.setInJar(remapped);
        forgePatches.setOutJar(forged);
        forgePatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/forgepatches.zip"));
        RemapSourcesTask javadocRemap = this.makeTask("addForgeJavadoc", RemapSourcesTask.class);
        javadocRemap.dependsOn(new Object[]{forgePatches});
        javadocRemap.setInJar(forged);
        javadocRemap.setOutJar(forgeJavaDocced);
        javadocRemap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        javadocRemap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        javadocRemap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        javadocRemap.setDoesJavadocs(true);
        ExtractTask extract = this.makeTask("extractForgeSrc", ExtractTask.class);
        extract.from(forgeJavaDocced);
        extract.into(recompSrc);
        extract.setIncludeEmptyDirs(false);
        extract.dependsOn(new Object[]{javadocRemap});
        extract.onlyIf(onlyIfCheck);
        JavaCompile recompTask = this.makeTask("recompForge", JavaCompile.class);
        recompTask.setSource((Object)recompSrc);
        recompTask.setDestinationDir(recompCls.call());
        recompTask.setSourceCompatibility("1.6");
        recompTask.setTargetCompatibility("1.6");
        recompTask.setClasspath((FileCollection)this.project.getConfigurations().getByName("minecraftDeps"));
        recompTask.dependsOn(new Object[]{extract});
        recompTask.onlyIf(onlyIfCheck);
        Jar repackageTask = this.makeTask("repackForge", Jar.class);
        repackageTask.from(new Object[]{recompSrc});
        repackageTask.from(new Object[]{recompCls});
        repackageTask.exclude(new String[]{"*.java", "**/*.java", "**.java"});
        repackageTask.dependsOn(new Object[]{recompTask});
        File out = forgeRecomp.call();
        repackageTask.setArchiveName(out.getName());
        repackageTask.setDestinationDir(out.getParentFile());
        repackageTask.onlyIf(onlyIfCheck);
    }
}

