/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public class FmlUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-binPatched.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fmlBin-{API_VERSION}.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/fmlBin-{API_VERSION}.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-srg.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/fml-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "repackFml"});
    }

    @Override
    public void afterEvaluate() {
        String apiVersion = ((UserExtension)this.getExtension()).getApiVersion();
        int buildNumber = Integer.parseInt(apiVersion.substring(apiVersion.lastIndexOf(46) + 1));
        if (buildNumber < 797 || buildNumber > 882) {
            throw new IllegalArgumentException("ForgeGradle 1.1 only works for FML versions 7.2.18.797 - 7.2.132.882");
        }
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)("cpw.mods:fml:" + apiVersion + ":userdev"));
        super.afterEvaluate();
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-binPatched.jar");
    }

    @Override
    protected String getDecompOut() {
        return "/fml-{API_VERSION}-decomp.jar";
    }

    @Override
    protected String getCacheDir() {
        return "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}";
    }

    @Override
    protected void createMcModuleDep(boolean isClean, DependencyHandler depHandler, String depConfig, boolean remove) {
        if (!remove) {
            final String repoDir = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts").call().getAbsolutePath();
            this.project.allprojects((Action)new Action<Project>(){

                public void execute(Project proj) {
                    FmlUserPlugin.this.addFlatRepo(proj, "fmlFlatRepo", repoDir);
                    proj.getLogger().info("Adding repo to " + proj.getPath() + " >> " + repoDir);
                }
            });
        }
        if (((UserExtension)this.getExtension()).isDecomp) {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"fmlSrc", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
            if (remove) {
                this.project.getConfigurations().getByName(depConfig).exclude((Map)ImmutableMap.of((Object)"module", (Object)"fmlBin"));
            }
        } else {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"fmlBin", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
            if (remove) {
                this.project.getConfigurations().getByName(depConfig).exclude((Map)ImmutableMap.of((Object)"module", (Object)"fmlSrc"));
            }
        }
    }

    @Override
    public void finalCall() {
        super.finalCall();
        if (((UserExtension)this.getExtension()).isDecomp) {
            boolean isClean = ((ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar")).isClean();
            ((ReobfTask)this.project.getTasks().getByName("reobf")).setRecompFile(this.delayedFile((isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts") + "/fmlSrc-{API_VERSION}.jar"));
        }
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        String prefix = isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        DelayedFile fmled = this.delayedFile(prefix + "/fml-{API_VERSION}-fmled.jar");
        final DelayedFile injected = this.delayedFile(prefix + "/fml-{API_VERSION}-src-injected.jar");
        DelayedFile remapped = this.delayedFile(prefix + "/fmlSrc-{API_VERSION}-sources.jar");
        final DelayedFile recompJar = this.delayedFile(prefix + "/fmlSrc-{API_VERSION}.jar");
        DelayedFile recompSrc = this.delayedFile("{BUILD_DIR}/tmp/recompSrc");
        DelayedFile recompCls = this.delayedFile("{BUILD_DIR}/tmp/recompCls");
        Spec onlyIfCheck = new Spec(){

            public boolean isSatisfiedBy(Object obj) {
                boolean didWork = ((Task)obj).dependsOnTaskDidWork();
                boolean exists = recompJar.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        };
        final PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        Zip inject = this.makeTask("addFmlSources", Zip.class);
        inject.onlyIf(new Spec(){

            public boolean isSatisfiedBy(Object o) {
                boolean didWork = fmlPatches.getDidWork();
                boolean exists = injected.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        });
        inject.dependsOn(new Object[]{"doFmlPatches"});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        File injectFile = injected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        RemapSourcesTask remapTask = this.makeTask("remapJar", RemapSourcesTask.class);
        remapTask.dependsOn(new Object[]{"addFmlSources"});
        remapTask.setInJar(injected);
        remapTask.setOutJar(remapped);
        remapTask.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remapTask.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remapTask.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        remapTask.setDoesJavadocs(true);
        ExtractTask extract = this.makeTask("extractFmlSrc", ExtractTask.class);
        extract.from(remapped);
        extract.into(recompSrc);
        extract.setIncludeEmptyDirs(false);
        extract.dependsOn(new Object[]{remapTask});
        extract.onlyIf(onlyIfCheck);
        JavaCompile recompTask = this.makeTask("recompFml", JavaCompile.class);
        recompTask.setSource((Object)recompSrc);
        recompTask.setDestinationDir(recompCls.call());
        recompTask.setSourceCompatibility("1.6");
        recompTask.setTargetCompatibility("1.6");
        recompTask.setClasspath((FileCollection)this.project.getConfigurations().getByName("minecraftDeps"));
        recompTask.dependsOn(new Object[]{extract});
        recompTask.onlyIf(onlyIfCheck);
        Jar repackageTask = this.makeTask("repackFml", Jar.class);
        repackageTask.from(new Object[]{recompSrc});
        repackageTask.from(new Object[]{recompCls});
        repackageTask.exclude(new String[]{"*.java", "**/*.java", "**.java"});
        repackageTask.dependsOn(new Object[]{recompTask});
        File out = recompJar.call();
        repackageTask.setArchiveName(out.getName());
        repackageTask.setDestinationDir(out.getParentFile());
        repackageTask.onlyIf(onlyIfCheck);
    }
}

