/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.extrastuff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ReobfExceptor {
    public File toReobfJar;
    public File deobfJar;
    public File methodCSV;
    public File fieldCSV;
    public File excConfig;
    Map<String, String> clsMap = Maps.newHashMap();
    Map<String, String> access = Maps.newHashMap();

    public void buildSrg(File inSrg, File outSrg) throws IOException {
        if (outSrg.isFile()) {
            outSrg.delete();
        }
        String fixed = (String)Files.readLines((File)inSrg, (Charset)Charset.defaultCharset(), (LineProcessor)new SrgLineProcessor(this.clsMap, this.access));
        Files.write((byte[])fixed.getBytes(), (File)outSrg);
    }

    public void doFirstThings() throws IOException {
        Map<String, String> csvData = this.readCSVs();
        JarInfo oldInfo = this.readJar(this.deobfJar);
        JarInfo newInfo = this.readJar(this.toReobfJar);
        this.clsMap = this.createClassMap(newInfo.map, newInfo.interfaces);
        this.renameAccess(oldInfo.access, csvData);
        this.access = this.mergeAccess(newInfo.access, oldInfo.access);
    }

    private Map<String, String> readCSVs() throws IOException {
        File[] csvs;
        final HashMap csvData = Maps.newHashMap();
        for (File f : csvs = new File[]{this.fieldCSV == null ? null : this.fieldCSV, this.methodCSV == null ? null : this.methodCSV}) {
            if (f == null) continue;
            Files.readLines((File)f, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Object>(){

                public boolean processLine(String line) throws IOException {
                    String[] s = line.split(",");
                    csvData.put(s[0], s[1]);
                    return true;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        return csvData;
    }

    private void renameAccess(Map<String, AccessInfo> data, Map<String, String> csvData) throws IOException {
        for (Map.Entry<String, AccessInfo> e : data.entrySet()) {
            AccessInfo i = e.getValue();
            String tmp = csvData.get(i.target_name);
            i.target_name = tmp == null ? i.target_name : tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarInfo readJar(File inJar) throws IOException {
        ZipInputStream zip = null;
        try {
            ZipEntry entry;
            try {
                zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(inJar)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            JarInfo reader = new JarInfo();
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                new ClassReader(ByteStreams.toByteArray((InputStream)zip)).accept((ClassVisitor)reader, 0);
            }
            JarInfo jarInfo = reader;
            return jarInfo;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Map<String, String> createClassMap(Map<String, String> markerMap, final List<String> interfaces) throws IOException {
        Map excMap = (Map)Files.readLines((File)this.excConfig, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Map<String, String>>(){
            Map<String, String> tmp = Maps.newHashMap();

            public boolean processLine(String line) throws IOException {
                if (line.contains(".") || !line.contains("=") || line.startsWith("#")) {
                    return true;
                }
                String[] s = line.split("=");
                if (!interfaces.contains(s[0])) {
                    this.tmp.put(s[0], s[1] + "_");
                }
                return true;
            }

            public Map<String, String> getResult() {
                return this.tmp;
            }
        });
        HashMap map = Maps.newHashMap();
        for (Map.Entry e : excMap.entrySet()) {
            String renamed = markerMap.get(e.getValue());
            if (renamed == null) continue;
            map.put(e.getKey(), renamed);
        }
        return map;
    }

    private Map<String, String> mergeAccess(Map<String, AccessInfo> old_data, Map<String, AccessInfo> new_data) {
        Iterator<Map.Entry<String, AccessInfo>> itr = old_data.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, AccessInfo> e = itr.next();
            String key = e.getKey();
            AccessInfo n = new_data.get(key);
            if (n == null || !e.getValue().targetEquals(n)) continue;
            itr.remove();
            new_data.remove(key);
        }
        HashMap matched = Maps.newHashMap();
        itr = old_data.entrySet().iterator();
        block1: while (itr.hasNext()) {
            AccessInfo _old = itr.next().getValue();
            Iterator<Map.Entry<String, AccessInfo>> itr2 = new_data.entrySet().iterator();
            while (itr2.hasNext()) {
                Map.Entry<String, AccessInfo> e2 = itr2.next();
                AccessInfo _new = e2.getValue();
                if (!_old.targetEquals(_new) || !_old.owner.equals(_new.owner) || !_old.desc.equals(_new.desc)) continue;
                matched.put(_old.owner + "/" + _old.name, _new.owner + "/" + _new.name);
                itr.remove();
                itr2.remove();
                continue block1;
            }
        }
        return matched;
    }

    private static class AccessInfo {
        public String owner;
        public String name;
        public String desc;
        public int opcode;
        public int access;
        public String target_owner;
        public String target_name;
        public String target_desc;

        public AccessInfo(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public void set(int opcode, String owner, String name, String desc) {
            if (this.opcode != 0) {
                throw new RuntimeException();
            }
            this.opcode = opcode;
            this.target_owner = owner;
            this.target_name = name;
            this.target_desc = desc;
        }

        public String toString() {
            String op = "UNKNOWN_" + this.opcode;
            switch (this.opcode) {
                case 178: {
                    op = "GETSTATIC";
                    break;
                }
                case 179: {
                    op = "PUTSTATIC";
                    break;
                }
                case 180: {
                    op = "GETFIELD";
                    break;
                }
                case 181: {
                    op = "PUTFIELD";
                    break;
                }
                case 182: {
                    op = "INVOKEVIRTUAL";
                    break;
                }
                case 183: {
                    op = "INVOKESPECIAL";
                    break;
                }
                case 184: {
                    op = "INVOKESTATIC";
                    break;
                }
                case 185: {
                    op = "INVOKEINTERFACE";
                }
            }
            return op + " " + this.target_owner + "/" + this.target_name + " " + this.target_desc;
        }

        public boolean targetEquals(AccessInfo o) {
            return this.toString().equals(o.toString());
        }
    }

    private static class JarInfo
    extends ClassVisitor {
        private final Map<String, String> map = Maps.newHashMap();
        private final List<String> interfaces = Lists.newArrayList();
        private final Map<String, AccessInfo> access = Maps.newHashMap();
        private String className;

        public JarInfo() {
            super(262144, null);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] ints) {
            this.className = name;
            if ((access & 0x200) == 512) {
                this.interfaces.add(this.className);
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.equals("__OBFID")) {
                this.map.put(String.valueOf(value) + "_", this.className);
            }
            return null;
        }

        public MethodVisitor visitMethod(int acc, String name, String desc, String signature, String[] exceptions) {
            if (this.className.startsWith("net/minecraft/") && name.startsWith("access$")) {
                String path = this.className + "/" + name + desc;
                final AccessInfo info = new AccessInfo(this.className, name, desc);
                info.access = acc;
                this.access.put(path, info);
                return new MethodVisitor(262144){

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        info.set(opcode, owner, name, desc);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        info.set(opcode, owner, name, desc);
                    }
                };
            }
            return null;
        }
    }

    private static class SrgLineProcessor
    implements LineProcessor<String> {
        Map<String, String> map;
        Map<String, String> access;
        StringBuilder out = new StringBuilder();
        Pattern reg = Pattern.compile("L([^;]+);");

        private SrgLineProcessor(Map<String, String> map, Map<String, String> access) {
            this.map = map;
            this.access = access;
        }

        private String rename(String cls) {
            String rename = this.map.get(cls);
            return rename == null ? cls : rename;
        }

        private String[] rsplit(String value, String delim) {
            int idx = value.lastIndexOf(delim);
            return new String[]{value.substring(0, idx), value.substring(idx + 1)};
        }

        public boolean processLine(String line) throws IOException {
            String[] split = line.split(" ");
            if (split[0].equals("CL:")) {
                split[2] = this.rename(split[2]);
            } else if (split[0].equals("FD:")) {
                String[] s = this.rsplit(split[2], "/");
                split[2] = this.rename(s[0]) + "/" + s[1];
            } else if (split[0].equals("MD:")) {
                String[] s = this.rsplit(split[3], "/");
                split[3] = this.rename(s[0]) + "/" + s[1];
                if (this.access.containsKey(split[3])) {
                    split[3] = this.access.get(split[3]);
                }
                Matcher m = this.reg.matcher(split[4]);
                StringBuffer b = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(b, "L" + this.rename(m.group(1)).replace("$", "\\$") + ";");
                }
                m.appendTail(b);
                split[4] = b.toString();
            }
            this.out.append(StringUtil.joinString(Arrays.asList(split), (String)" ")).append('\n');
            return true;
        }

        public String getResult() {
            return this.out.toString();
        }
    }
}

