/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GFileUtils;

public class ZipFileTree
implements MinimalFileTree {
    private final File zipFile;

    public ZipFileTree(File zipFile) {
        this.zipFile = zipFile;
    }

    public String getDisplayName() {
        return String.format("ZIP '%s'", this.zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        if (!this.zipFile.exists()) {
            DeprecationLogger.nagUserOfDeprecatedBehaviour((String)String.format("The specified zip file %s does not exist and will be silently ignored", this.getDisplayName()));
            return;
        }
        if (!this.zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        try {
            ZipFile zip = new ZipFile(this.zipFile);
            try {
                TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    entriesByName.put(entry.getName(), entry);
                }
                Iterator sortedEntries = entriesByName.values().iterator();
                while (!stopFlag.get() && sortedEntries.hasNext()) {
                    ZipEntry entry = (ZipEntry)sortedEntries.next();
                    if (entry.isDirectory()) {
                        visitor.visitDir((FileVisitDetails)new DetailsImpl(entry, zip, stopFlag));
                        continue;
                    }
                    visitor.visitFile((FileVisitDetails)new DetailsImpl(entry, zip, stopFlag));
                }
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not expand %s.", this.getDisplayName()), (Throwable)e);
        }
    }

    private class DetailsImpl
    implements FileVisitDetails {
        private final ZipEntry entry;
        private final ZipFile zip;
        private final AtomicBoolean stopFlag;
        private File file;

        public DetailsImpl(ZipEntry entry, ZipFile zip, AtomicBoolean stopFlag) {
            this.entry = entry;
            this.zip = zip;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("zip entry %s!%s", ZipFileTree.this.zipFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.entry.getName());
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getName() {
            return this.getRelativePath().getLastName();
        }

        public String getPath() {
            return this.getRelativePath().getPathString();
        }

        public void copyTo(OutputStream outstr) {
            try {
                InputStream inputStream = this.open();
                try {
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outstr);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public boolean copyTo(File target) {
            this.validateTimeStamps();
            try {
                if (this.isDirectory()) {
                    GFileUtils.mkdirs((File)target);
                } else {
                    GFileUtils.mkdirs((File)target.getParentFile());
                    this.copyFile(target);
                }
                return true;
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not copy %s to '%s'.", this.getDisplayName(), target), (Throwable)e);
            }
        }

        private void validateTimeStamps() {
            long lastModified = this.getLastModified();
            if (lastModified < 0L) {
                throw new GradleException(String.format("Invalid Timestamp %s for '%s'.", lastModified, this.getDisplayName()));
            }
        }

        private void copyFile(File target) throws IOException {
            FileOutputStream outputStream = new FileOutputStream(target);
            try {
                this.copyTo(outputStream);
            }
            finally {
                outputStream.close();
            }
        }

        public int getMode() {
            return this.isDirectory() ? 493 : 420;
        }
    }
}

