/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user.reobf;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.gradle.delayed.DelayedThingy;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ObfArtifact;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ReobfTask
extends DefaultTask {
    private final DefaultDomainObjectSet<ObfArtifact> obfOutput = new DefaultDomainObjectSet(ObfArtifact.class);
    private boolean useRG = false;

    public ReobfTask() {
        this.getInputs().files(new Object[]{new Closure<Object>(this.obfOutput){

            public Object call(Object ... objects) {
                return ReobfTask.this.getFilesToObfuscate();
            }
        }});
        this.getOutputs().files(new Object[]{new Closure<Object>(this.obfOutput){

            public Object call(Object ... objects) {
                return ReobfTask.this.getObfuscatedFiles();
            }
        }});
    }

    public void reobf(Task task, Action<ArtifactSpec> artifactSpec) {
        this.reobf(task, (Closure<Object>)new ActionClosure(artifactSpec));
    }

    public void reobf(Task task, Closure<Object> artifactSpec) {
        if (!(task instanceof AbstractArchiveTask)) {
            throw new InvalidUserDataException("You cannot reobfuscate tasks that are not 'archive' tasks, such as 'jar', 'zip' etc. (you tried to sign $task)");
        }
        ArtifactSpec spec = new ArtifactSpec((AbstractArchiveTask)task);
        artifactSpec.call((Object)spec);
        this.dependsOn(new Object[]{task});
        this.addArtifact(new ObfArtifact(new DelayedThingy(task), spec, this));
    }

    public void reobf(Task ... tasks) {
        for (Task task : tasks) {
            if (!(task instanceof AbstractArchiveTask)) {
                throw new InvalidUserDataException("You cannot reobfuscate tasks that are not 'archive' tasks, such as 'jar', 'zip' etc. (you tried to sign $task)");
            }
            this.dependsOn(new Object[]{(AbstractArchiveTask)task});
            this.addArtifact(new ObfArtifact(new DelayedThingy(task), new ArtifactSpec(this.getProject()), this));
        }
    }

    public void reobf(PublishArtifact art, Action<ArtifactSpec> artifactSpec) {
        this.reobf(art, (Closure<Object>)new ActionClosure(artifactSpec));
    }

    public void reobf(PublishArtifact publishArtifact, Closure<Object> artifactSpec) {
        ArtifactSpec spec = new ArtifactSpec(publishArtifact, this.getProject());
        artifactSpec.call((Object)spec);
        this.dependsOn(new Object[]{publishArtifact});
        this.addArtifact(new ObfArtifact(publishArtifact, spec, this));
    }

    public void reobf(PublishArtifact ... publishArtifacts) {
        for (PublishArtifact publishArtifact : publishArtifacts) {
            this.dependsOn(new Object[]{publishArtifact});
            this.addArtifact(new ObfArtifact(publishArtifact, new ArtifactSpec(publishArtifact, this.getProject()), this));
        }
    }

    public void reobf(File file, Action<ArtifactSpec> artifactSpec) {
        this.reobf(file, (Closure<Object>)new ActionClosure(artifactSpec));
    }

    public void reobf(File file, Closure<Object> artifactSpec) {
        ArtifactSpec spec = new ArtifactSpec(file, this.getProject());
        artifactSpec.call((Object)spec);
        this.addArtifact(new ObfArtifact(file, spec, this));
    }

    public void reobf(File ... files) {
        for (File file : files) {
            this.addArtifact(new ObfArtifact(file, new ArtifactSpec(file, this.getProject()), this));
        }
    }

    public void reobf(Configuration configuration, final Closure<Object> artifactSpec) {
        configuration.getAllArtifacts().all((Action)new Action<PublishArtifact>(){

            public void execute(PublishArtifact artifact) {
                if (!(artifact instanceof ObfArtifact)) {
                    ReobfTask.this.reobf(artifact, (Closure<Object>)artifactSpec);
                }
            }
        });
        configuration.getAllArtifacts().whenObjectRemoved((Action)new Action<PublishArtifact>(){

            public void execute(PublishArtifact artifact) {
                ObfArtifact removed = null;
                for (ObfArtifact it : ReobfTask.this.obfOutput) {
                    if (it.toObfArtifact != artifact) continue;
                    removed = it;
                    break;
                }
                if (removed != null) {
                    ReobfTask.this.obfOutput.remove(removed);
                }
            }
        });
    }

    public void reobf(Configuration ... configurations) {
        for (Configuration configuration : configurations) {
            configuration.getAllArtifacts().all((Action)new Action<PublishArtifact>(){

                public void execute(PublishArtifact artifact) {
                    if (!(artifact instanceof ObfArtifact)) {
                        ReobfTask.this.reobf(artifact);
                    }
                }
            });
            configuration.getAllArtifacts().whenObjectRemoved((Action)new Action<PublishArtifact>(){

                public void execute(PublishArtifact artifact) {
                    ObfArtifact removed = null;
                    for (ObfArtifact it : ReobfTask.this.obfOutput) {
                        if (it.toObfArtifact != artifact) continue;
                        removed = it;
                        break;
                    }
                    if (removed != null) {
                        ReobfTask.this.obfOutput.remove(removed);
                    }
                }
            });
        }
    }

    @TaskAction
    public void generate() throws Exception {
        for (ObfArtifact obf : this.getObfuscated()) {
            obf.generate();
        }
    }

    private void addArtifact(ObfArtifact artifact) {
        this.obfOutput.add((Object)artifact);
    }

    DomainObjectSet<ObfArtifact> getObfuscated() {
        return this.obfOutput;
    }

    FileCollection getFilesToObfuscate() {
        ArrayList<File> collect = new ArrayList<File>();
        for (ObfArtifact obf : this.getObfuscated()) {
            if (obf == null || obf.getToObf() == null) continue;
            collect.add(obf.getToObf());
        }
        return new SimpleFileCollection(collect.toArray(new File[collect.size()]));
    }

    FileCollection getObfuscatedFiles() {
        ArrayList<File> collect = new ArrayList<File>();
        for (ObfArtifact obf : this.getObfuscated()) {
            if (obf == null || obf.getFile() == null) continue;
            collect.add(obf.getFile());
        }
        return new SimpleFileCollection(collect.toArray(new File[collect.size()]));
    }

    public boolean getUseRetroGuard() {
        return this.useRG;
    }

    public void setUseRetroGuard(boolean useRG) {
        this.useRG = useRG;
    }

    private class ActionClosure
    extends Closure<Object> {
        private final Action act;

        public ActionClosure(Action artifactSpec) {
            super(null);
            this.act = artifactSpec;
        }

        public Object call(Object obj) {
            this.act.execute(obj);
            return null;
        }
    }
}

