/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.TaskAction;

public class SubprojectTask
extends DefaultTask {
    private DelayedFile buildFile;
    private String tasks;
    private LinkedList<Action<Project>> configureProject = new LinkedList();
    private Action<Task> configureTask;

    @TaskAction
    public void doTask() throws IOException {
        Project childProj = FmlDevPlugin.getProject(this.getBuildFile(), this.getProject());
        for (Action action : this.configureProject) {
            if (action == null) continue;
            action.execute((Object)childProj);
        }
        for (String task : this.tasks.split(" ")) {
            Set list = childProj.getTasksByName(task, false);
            for (Task t : list) {
                if (this.configureTask != null) {
                    this.configureTask.execute((Object)t);
                }
                this.executeTask((AbstractTask)t);
            }
        }
        System.gc();
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    public File getBuildFile() {
        return this.buildFile.call();
    }

    public void setBuildFile(DelayedFile buildFile) {
        this.buildFile = buildFile;
    }

    public String getTasks() {
        return this.tasks;
    }

    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    public Action<Task> getConfigureTask() {
        return this.configureTask;
    }

    public void setConfigureTask(Action<Task> configureTask) {
        this.configureTask = configureTask;
    }

    public void configureProject(Action<Project> action) {
        this.configureProject.add(action);
    }
}

