/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.EditJarTask;
import org.gradle.api.tasks.InputFile;

public class RelaceJavadocsTask
extends EditJarTask {
    @InputFile
    private DelayedFile methodsCsv;
    @InputFile
    private DelayedFile fieldsCsv;
    private final Map<String, Map<String, String>> methods = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> fields = new HashMap<String, Map<String, String>>();
    private static final Pattern METHOD = Pattern.compile("^( {4}|\\t)// JAVADOC METHOD \\$\\$ (func\\_\\d+)$");
    private static final Pattern FIELD = Pattern.compile("^( {4}|\\t)// JAVADOC FIELD \\$\\$ (func\\_\\d+)$");

    @Override
    public void doStuffBefore() throws Throwable {
        HashMap<String, String> temp;
        CSVReader reader = RelaceJavadocsTask.getReader(this.getMethodsCsv());
        for (String[] s : reader.readAll()) {
            temp = new HashMap<String, String>();
            temp.put("name", s[1]);
            temp.put("javadoc", s[3]);
            this.methods.put(s[0], temp);
        }
        reader = RelaceJavadocsTask.getReader(this.getFieldsCsv());
        for (String[] s : reader.readAll()) {
            temp = new HashMap();
            temp.put("name", s[1]);
            temp.put("javadoc", s[3]);
            this.fields.put(s[0], temp);
        }
    }

    public static CSVReader getReader(File file) throws IOException {
        return new CSVReader((Reader)Files.newReader((File)file, (Charset)Charset.defaultCharset()), ',', '\"', '\\', 1, false);
    }

    @Override
    public String asRead(String text) {
        String prevLine = null;
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : StringUtils.lines(text)) {
            String javadoc;
            String name;
            Matcher matcher = METHOD.matcher(line);
            if (matcher.find() && this.methods.containsKey(name = matcher.group(2)) && this.methods.get(name).containsKey("name")) {
                javadoc = this.methods.get(name).get("javadoc");
                if (Strings.isNullOrEmpty((String)javadoc)) {
                    line = "";
                } else {
                    line = this.buildJavadoc(matcher.group(1), javadoc, true);
                    if (!Strings.isNullOrEmpty((String)prevLine) && !prevLine.endsWith("{")) {
                        line = Constants.NEWLINE + line;
                    }
                }
            }
            if ((matcher = FIELD.matcher(line)).find() && this.fields.containsKey(name = matcher.group(2))) {
                javadoc = this.fields.get(name).get("javadoc");
                if (Strings.isNullOrEmpty((String)javadoc)) {
                    line = "";
                } else {
                    line = this.buildJavadoc(matcher.group(1), javadoc, false);
                    if (!Strings.isNullOrEmpty((String)prevLine) && !prevLine.endsWith("{")) {
                        line = Constants.NEWLINE + line;
                    }
                }
            }
            prevLine = line;
            newLines.add(line);
        }
        return Joiner.on((String)Constants.NEWLINE).join(newLines);
    }

    private String buildJavadoc(String indent, String javadoc, boolean isMethod) {
        StringBuilder builder = new StringBuilder();
        if (javadoc.length() >= 70 || isMethod) {
            List<String> list = RelaceJavadocsTask.wrapText(javadoc, 120 - (indent.length() + 3));
            builder.append(indent);
            builder.append("/**");
            builder.append(Constants.NEWLINE);
            for (String line : list) {
                builder.append(indent);
                builder.append(" * ");
                builder.append(line);
                builder.append(Constants.NEWLINE);
            }
            builder.append(indent);
            builder.append(" */");
            builder.append(Constants.NEWLINE);
        } else {
            builder.append(indent);
            builder.append("/** ");
            builder.append(javadoc);
            builder.append(" */");
            builder.append(Constants.NEWLINE);
        }
        return builder.toString().replace(indent, indent);
    }

    private static List<String> wrapText(String text, int len) {
        if (text == null) {
            return new ArrayList<String>();
        }
        if (len <= 0) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        if (text.length() <= len) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == ' ' || c == ',' || c == '-') {
                int tempNum;
                word.append(c);
                int n = tempNum = Character.isWhitespace(c) ? 1 : 0;
                if (line.length() + word.length() - tempNum > len) {
                    lines.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append((CharSequence)word);
                word.delete(0, word.length());
                continue;
            }
            word.append(c);
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        ArrayList<String> temp = new ArrayList<String>(lines.size());
        for (String s : lines) {
            temp.add(s.trim());
        }
        return temp;
    }

    @Override
    public void doStuffMiddle() throws Throwable {
    }

    @Override
    public void doStuffAfter() throws Throwable {
    }

    public File getMethodsCsv() {
        return this.methodsCsv.call();
    }

    public void setMethodsCsv(DelayedFile methodsCsv) {
        this.methodsCsv = methodsCsv;
    }

    public File getFieldsCsv() {
        return this.fieldsCsv.call();
    }

    public void setFieldsCsv(DelayedFile fieldsCsv) {
        this.fieldsCsv = fieldsCsv;
    }
}

