/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.patching.ContextualPatch;
import net.minecraftforge.gradle.tasks.abstractutil.EditJarTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;

public class PatchJarTask
extends EditJarTask {
    @InputFiles
    private DelayedFile inPatches;
    private ContextProvider PROVIDER;

    @Override
    public String asRead(String file) {
        return file;
    }

    @Override
    public void doStuffBefore() throws Throwable {
        this.PROVIDER = new ContextProvider(this.sourceMap);
    }

    @Override
    public void doStuffMiddle() throws Throwable {
        this.getLogger().info("Reading patches");
        ArrayList<ContextualPatch> patches = this.readPatches(this.getInPatches());
        boolean fuzzed = false;
        this.getLogger().info("Applying patches");
        Throwable failure = null;
        for (ContextualPatch patch : patches) {
            List<ContextualPatch.PatchReport> errors = patch.patch(false);
            for (ContextualPatch.PatchReport report : errors) {
                if (!report.getStatus().isSuccess()) {
                    this.getLogger().log(LogLevel.ERROR, "Patching failed: " + this.PROVIDER.strip(report.getTarget()) + " " + report.getFailure().getMessage());
                    for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                        if (hunk.getStatus().isSuccess()) continue;
                        this.getLogger().error("Hunk " + hunk.getHunkID() + " failed! " + (hunk.getFailure() != null ? hunk.getFailure().getMessage() : ""));
                    }
                    if (failure != null) continue;
                    failure = report.getFailure();
                    continue;
                }
                if (report.getStatus() == ContextualPatch.PatchStatus.Fuzzed) {
                    this.getLogger().log(LogLevel.INFO, "Patching fuzzed: " + this.PROVIDER.strip(report.getTarget()));
                    fuzzed = true;
                    for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                        if (hunk.getStatus().isSuccess()) continue;
                        this.getLogger().info("Hunk " + hunk.getHunkID() + " fuzzed " + hunk.getFuzz() + "!");
                    }
                    if (failure != null) continue;
                    failure = report.getFailure();
                    continue;
                }
                this.getLogger().info("Patch succeeded: " + this.PROVIDER.strip(report.getTarget()));
            }
        }
        if (fuzzed) {
            this.getLogger().lifecycle("Patches Fuzzed!");
        }
        if (failure != null) {
            throw failure;
        }
    }

    private ArrayList<ContextualPatch> readPatches(FileCollection patchFiles) throws IOException {
        ArrayList<ContextualPatch> patches = new ArrayList<ContextualPatch>();
        for (File file : patchFiles.getFiles()) {
            if (!file.getPath().endsWith(".patch")) continue;
            patches.add(this.readPatch(file));
        }
        return patches;
    }

    public ContextualPatch readPatch(File file) throws IOException {
        this.getLogger().debug("Reading patch file: " + file);
        return ContextualPatch.create(Files.toString((File)file, (Charset)Charset.defaultCharset()), this.PROVIDER).setAccessC14N(true).setMaxFuzz(0);
    }

    public FileCollection getInPatches() {
        File file = this.inPatches.call();
        if (file.isDirectory()) {
            return this.getProject().fileTree((Object)file);
        }
        if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
            return this.getProject().zipTree((Object)file);
        }
        if (file.getName().endsWith(".tar") || file.getName().endsWith(".gz")) {
            return this.getProject().tarTree((Object)file);
        }
        return this.getProject().files(new Object[]{file});
    }

    public void setInPatches(DelayedFile inPatches) {
        this.inPatches = inPatches;
    }

    @Override
    public void doStuffAfter() throws Throwable {
    }

    private class ContextProvider
    implements ContextualPatch.IContextProvider {
        private Map<String, String> fileMap;
        private final int STRIP = 3;

        public ContextProvider(Map<String, String> fileMap) {
            this.fileMap = fileMap;
        }

        public String strip(String target) {
            target = target.replace('\\', '/');
            int index = 0;
            for (int x = 0; x < 3; ++x) {
                index = target.indexOf(47, index) + 1;
            }
            return target.substring(index);
        }

        @Override
        public List<String> getData(String target) {
            if (this.fileMap.containsKey(target = this.strip(target))) {
                String[] lines = this.fileMap.get(target).split("\r\n|\r|\n");
                ArrayList<String> ret = new ArrayList<String>();
                for (String line : lines) {
                    ret.add(line);
                }
                return ret;
            }
            return null;
        }

        @Override
        public void setData(String target, List<String> data) {
            target = this.strip(target);
            this.fileMap.put(target, Joiner.on((String)Constants.NEWLINE).join(data));
        }
    }
}

