/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import groovy.lang.Closure;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class MergeJarsTask
extends CachedTask {
    @InputFile
    private Closure<File> mergeCfg;
    @InputFile
    private Closure<File> client;
    @InputFile
    private Closure<File> server;
    @OutputFile
    @CachedTask.Cached
    private Closure<File> outJar;
    private static HashMap<String, ClassInfo> shared = new HashMap();
    private static HashSet<String> copyToServer = new HashSet();
    private static HashSet<String> copyToClient = new HashSet();
    private static HashSet<String> dontAnnotate = new HashSet();
    private static HashSet<String> dontProcess = new HashSet();
    private static final boolean DEBUG = false;

    @TaskAction
    public void doTask() throws IOException {
        this.readConfig(this.getMergeCfg());
        this.processJar(this.getClient(), this.getServer(), this.getOutJar());
    }

    private boolean readConfig(File mapFile) {
        try {
            String line;
            FileInputStream fstream = new FileInputStream(mapFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                line = line.split("#")[0];
                char cmd = line.charAt(0);
                line = line.substring(1).trim();
                switch (cmd) {
                    case '!': {
                        dontAnnotate.add(line);
                        break;
                    }
                    case '<': {
                        copyToClient.add(line);
                        break;
                    }
                    case '>': {
                        copyToServer.add(line);
                        break;
                    }
                    case '^': {
                        dontProcess.add(line);
                    }
                }
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("Error: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJar(File clientInFile, File serverInFile, File outFile) throws IOException {
        ZipFile cInJar = null;
        ZipFile sInJar = null;
        ZipOutputStream outJar = null;
        try {
            try {
                cInJar = new ZipFile(clientInFile);
                sInJar = new ZipFile(serverInFile);
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            try {
                outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open output file: " + e.getMessage());
            }
            HashSet<String> resources = new HashSet<String>();
            HashMap<String, ZipEntry> cClasses = this.getClassEntries(cInJar, outJar, resources);
            HashMap<String, ZipEntry> sClasses = this.getClassEntries(sInJar, outJar, resources);
            HashSet<String> cAdded = new HashSet<String>();
            for (Map.Entry<String, ZipEntry> entry : cClasses.entrySet()) {
                String name = entry.getKey();
                ZipEntry cEntry = entry.getValue();
                ZipEntry sEntry = sClasses.get(name);
                if (sEntry == null) {
                    if (!copyToServer.contains(name)) {
                        this.copyClass(cInJar, cEntry, outJar, true);
                        cAdded.add(name);
                        continue;
                    }
                    this.copyClass(cInJar, cEntry, outJar, true);
                    cAdded.add(name);
                    continue;
                }
                sClasses.remove(name);
                ClassInfo info = new ClassInfo(name);
                shared.put(name, info);
                byte[] cData = this.readEntry(cInJar, entry.getValue());
                byte[] sData = this.readEntry(sInJar, sEntry);
                byte[] data = this.processClass(cData, sData, info);
                ZipEntry newEntry = new ZipEntry(cEntry.getName());
                outJar.putNextEntry(newEntry);
                outJar.write(data);
                cAdded.add(name);
            }
            for (Map.Entry<String, ZipEntry> entry : sClasses.entrySet()) {
                this.copyClass(sInJar, entry.getValue(), outJar, false);
            }
            for (String name : new String[]{SideOnly.class.getName(), Side.class.getName()}) {
                String eName = name.replace(".", "/");
                String classPath = eName + ".class";
                ZipEntry newEntry = new ZipEntry(classPath);
                System.out.printf("Adding %s\n", classPath);
                if (cAdded.contains(eName)) continue;
                outJar.putNextEntry(newEntry);
                outJar.write(MergeJarsTask.getClassBytes(name));
            }
        }
        finally {
            if (cInJar != null) {
                try {
                    cInJar.close();
                }
                catch (IOException iOException) {}
            }
            if (sInJar != null) {
                try {
                    sInJar.close();
                }
                catch (IOException iOException) {}
            }
            if (outJar != null) {
                try {
                    outJar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void copyClass(ZipFile inJar, ZipEntry entry, ZipOutputStream outJar, boolean isClientOnly) throws IOException {
        ClassReader reader = new ClassReader(this.readEntry(inJar, entry));
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        if (!dontAnnotate.contains(classNode.name)) {
            if (classNode.visibleAnnotations == null) {
                classNode.visibleAnnotations = new ArrayList();
            }
            classNode.visibleAnnotations.add(this.getSideAnn(isClientOnly));
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] data = writer.toByteArray();
        ZipEntry newEntry = new ZipEntry(entry.getName());
        if (outJar != null) {
            outJar.putNextEntry(newEntry);
            outJar.write(data);
        }
    }

    private byte[] readEntry(ZipFile inFile, ZipEntry entry) throws IOException {
        return ByteStreams.toByteArray((InputStream)inFile.getInputStream(entry));
    }

    private AnnotationNode getSideAnn(boolean isClientOnly) {
        AnnotationNode ann = new AnnotationNode(Type.getDescriptor(SideOnly.class));
        ann.values = new ArrayList();
        ann.values.add("value");
        ann.values.add(new String[]{Type.getDescriptor(Side.class), isClientOnly ? "CLIENT" : "SERVER"});
        return ann;
    }

    private HashMap<String, ZipEntry> getClassEntries(ZipFile inFile, ZipOutputStream outFile, HashSet<String> resources) throws IOException {
        HashMap<String, ZipEntry> ret = new HashMap<String, ZipEntry>();
        block0: for (ZipEntry zipEntry : Collections.list(inFile.entries())) {
            String entryName = zipEntry.getName();
            if ("META-INF/MANIFEST.MF".equals(entryName) || zipEntry.isDirectory()) continue;
            for (String filter : dontProcess) {
                if (!entryName.startsWith(filter)) continue;
                continue block0;
            }
            if (!entryName.endsWith(".class") || entryName.startsWith(".")) {
                if (resources.contains(entryName)) continue;
                ZipEntry newEntry = new ZipEntry(entryName);
                outFile.putNextEntry(newEntry);
                outFile.write(this.readEntry(inFile, zipEntry));
                resources.add(entryName);
                continue;
            }
            ret.put(entryName.replace(".class", ""), zipEntry);
        }
        return ret;
    }

    public static byte[] getClassBytes(String name) throws IOException {
        InputStream classStream = null;
        try {
            classStream = MergeJarsTask.class.getResourceAsStream("/" + name.replace('.', '/').concat(".class"));
            byte[] byArray = ByteStreams.toByteArray((InputStream)classStream);
            return byArray;
        }
        finally {
            if (classStream != null) {
                classStream.close();
            }
        }
    }

    public byte[] processClass(byte[] cIn, byte[] sIn, ClassInfo info) {
        ClassNode cClassNode = this.getClassNode(cIn);
        ClassNode sClassNode = this.getClassNode(sIn);
        this.processFields(cClassNode, sClassNode, info);
        this.processMethods(cClassNode, sClassNode, info);
        ClassWriter writer = new ClassWriter(1);
        cClassNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private ClassNode getClassNode(byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private void processFields(ClassNode cClass, ClassNode sClass, ClassInfo info) {
        int x;
        List cFields = cClass.fields;
        List sFields = sClass.fields;
        int sI = 0;
        for (x = 0; x < cFields.size(); ++x) {
            FieldNode cF = (FieldNode)cFields.get(x);
            if (sI < sFields.size()) {
                if (!cF.name.equals(((FieldNode)sFields.get((int)sI)).name)) {
                    boolean serverHas = false;
                    for (int y = sI + 1; y < sFields.size(); ++y) {
                        if (!cF.name.equals(((FieldNode)sFields.get((int)y)).name)) continue;
                        serverHas = true;
                        break;
                    }
                    if (serverHas) {
                        boolean clientHas = false;
                        FieldNode sF = (FieldNode)sFields.get(sI);
                        for (int y = x + 1; y < cFields.size(); ++y) {
                            if (!sF.name.equals(((FieldNode)cFields.get((int)y)).name)) continue;
                            clientHas = true;
                            break;
                        }
                        if (!clientHas) {
                            if (sF.visibleAnnotations == null) {
                                sF.visibleAnnotations = new ArrayList();
                            }
                            sF.visibleAnnotations.add(this.getSideAnn(false));
                            cFields.add(x++, sF);
                            info.sField.add(sF);
                        }
                    } else {
                        if (cF.visibleAnnotations == null) {
                            cF.visibleAnnotations = new ArrayList();
                        }
                        cF.visibleAnnotations.add(this.getSideAnn(true));
                        sFields.add(sI, cF);
                        info.cField.add(cF);
                    }
                }
            } else {
                if (cF.visibleAnnotations == null) {
                    cF.visibleAnnotations = new ArrayList();
                }
                cF.visibleAnnotations.add(this.getSideAnn(true));
                sFields.add(sI, cF);
                info.cField.add(cF);
            }
            ++sI;
        }
        if (sFields.size() != cFields.size()) {
            for (x = cFields.size(); x < sFields.size(); ++x) {
                FieldNode sF = (FieldNode)sFields.get(x);
                if (sF.visibleAnnotations == null) {
                    sF.visibleAnnotations = new ArrayList();
                }
                sF.visibleAnnotations.add(this.getSideAnn(true));
                cFields.add(x++, sF);
                info.sField.add(sF);
            }
        }
    }

    private void processMethods(ClassNode cClass, ClassNode sClass, ClassInfo info) {
        String clientName;
        List cMethods = cClass.methods;
        List sMethods = sClass.methods;
        LinkedHashSet allMethods = Sets.newLinkedHashSet();
        int cPos = 0;
        int sPos = 0;
        int cLen = cMethods.size();
        int sLen = sMethods.size();
        String lastName = clientName = "";
        String serverName = "";
        block0: while (cPos < cLen || sPos < sLen) {
            MethodWrapper mw;
            while (sPos < sLen) {
                MethodNode sM = (MethodNode)sMethods.get(sPos);
                serverName = sM.name;
                if (!serverName.equals(lastName) && cPos != cLen) break;
                mw = new MethodWrapper(sM);
                mw.server = true;
                allMethods.add(mw);
                if (++sPos < sLen) continue;
            }
            while (cPos < cLen) {
                MethodNode cM = (MethodNode)cMethods.get(cPos);
                clientName = cM.name;
                lastName = clientName;
                if (!clientName.equals(lastName) && sPos != sLen) continue block0;
                mw = new MethodWrapper(cM);
                mw.client = true;
                allMethods.add(mw);
                if (++cPos < cLen) continue;
                continue block0;
            }
        }
        cMethods.clear();
        sMethods.clear();
        for (MethodWrapper mw : allMethods) {
            cMethods.add(mw.node);
            sMethods.add(mw.node);
            if (mw.server && mw.client) continue;
            if (((MethodWrapper)mw).node.visibleAnnotations == null) {
                ((MethodWrapper)mw).node.visibleAnnotations = Lists.newArrayListWithExpectedSize((int)1);
            }
            ((MethodWrapper)mw).node.visibleAnnotations.add(this.getSideAnn(mw.client));
            if (mw.client) {
                info.sMethods.add(mw.node);
                continue;
            }
            info.cMethods.add(mw.node);
        }
    }

    public File getClient() {
        return (File)this.client.call();
    }

    public void setClient(Closure<File> client) {
        this.client = client;
    }

    public File getMergeCfg() {
        return (File)this.mergeCfg.call();
    }

    public void setMergeCfg(Closure<File> mergeCfg) {
        this.mergeCfg = mergeCfg;
    }

    public File getOutJar() {
        return (File)this.outJar.call();
    }

    public void setOutJar(Closure<File> outJar) {
        this.outJar = outJar;
    }

    public File getServer() {
        return (File)this.server.call();
    }

    public void setServer(Closure<File> server) {
        this.server = server;
    }

    private class ClassInfo {
        public String name;
        public ArrayList<FieldNode> cField = new ArrayList();
        public ArrayList<FieldNode> sField = new ArrayList();
        public ArrayList<MethodNode> cMethods = new ArrayList();
        public ArrayList<MethodNode> sMethods = new ArrayList();

        public ClassInfo(String name) {
            this.name = name;
        }

        public boolean isSame() {
            return this.cField.size() == 0 && this.sField.size() == 0 && this.cMethods.size() == 0 && this.sMethods.size() == 0;
        }
    }

    private class MethodWrapper {
        private MethodNode node;
        public boolean client;
        public boolean server;

        public MethodWrapper(MethodNode node) {
            this.node = node;
        }

        public boolean equals(Object obj) {
            boolean eq;
            if (obj == null || !(obj instanceof MethodWrapper)) {
                return false;
            }
            MethodWrapper mw = (MethodWrapper)obj;
            boolean bl = eq = Objects.equal((Object)this.node.name, (Object)mw.node.name) && Objects.equal((Object)this.node.desc, (Object)mw.node.desc);
            if (eq) {
                mw.client = this.client | mw.client;
                mw.server = this.server | mw.server;
                this.client |= mw.client;
                this.server |= mw.server;
            }
            return eq;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.node.name, this.node.desc});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.node.name).add("desc", (Object)this.node.desc).add("server", this.server).add("client", this.client).toString();
        }
    }
}

