/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.common.version.AssetIndex;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.xml.sax.SAXException;

public class DownloadAssetsTask
extends DefaultTask {
    DelayedFile assetsDir;
    @Input
    Closure<AssetIndex> index;
    private boolean errored = false;
    private final ConcurrentLinkedQueue<Asset> filesLeft = new ConcurrentLinkedQueue();
    private final ArrayList<AssetsThread> threads = new ArrayList();
    private final File minecraftDir = new File(Constants.getMinecraftDirectory(), "assets/objects");
    private static final int MAX_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int MAX_TRIES = 5;

    @TaskAction
    public void doTask() throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        File out = new File(this.getAssetsDir(), "objects");
        out.mkdirs();
        AssetIndex index = this.getIndex();
        for (Map.Entry<String, AssetIndex.AssetEntry> e : index.objects.entrySet()) {
            Asset asset = new Asset(e.getValue().hash, e.getValue().size);
            File file = new File(out, asset.path);
            if (file.exists() && file.length() != asset.size) {
                file.delete();
            }
            if (file.exists()) continue;
            this.filesLeft.offer(asset);
        }
        this.getLogger().info("Finished parsing JSON");
        int max = this.filesLeft.size();
        this.getLogger().info("Files Missing: " + max + "/" + index.objects.size());
        int threadNum = max / 100;
        if (threadNum == 0 && max > 0) {
            ++threadNum;
        }
        for (int i = 0; i < threadNum; ++i) {
            this.spawnThread();
        }
        this.getLogger().info("Threads initially spawned: " + threadNum);
        while (this.stillRunning()) {
            int done = max - this.filesLeft.size();
            this.getLogger().lifecycle("Current status: " + done + "/" + max + "   " + (int)((double)done / (double)max * 100.0) + "%");
            this.spawnThread();
            Thread.sleep(1000L);
        }
        if (this.errored) {
            throw new RuntimeException("Something went wrong with the Assets downloading!");
        }
    }

    private void spawnThread() {
        if (this.threads.size() < MAX_THREADS) {
            this.getLogger().debug("Spawning thread #" + (this.threads.size() + 1));
            AssetsThread thread = new AssetsThread();
            thread.start();
            this.threads.add(thread);
        }
    }

    private boolean stillRunning() {
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            return true;
        }
        this.getLogger().info("All " + this.threads.size() + " threads Complete");
        return false;
    }

    public File getAssetsDir() {
        return this.assetsDir.call();
    }

    public void setAssetsDir(DelayedFile assetsDir) {
        this.assetsDir = assetsDir;
    }

    public AssetIndex getIndex() {
        return (AssetIndex)this.index.call();
    }

    public void setIndex(Closure<AssetIndex> index) {
        this.index = index;
    }

    private class AssetsThread
    extends Thread {
        public AssetsThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Asset asset;
            block2: while ((asset = (Asset)DownloadAssetsTask.this.filesLeft.poll()) != null) {
                for (int i = 1; i < 6; ++i) {
                    try {
                        File localMc;
                        File file = new File(DownloadAssetsTask.this.getAssetsDir(), "objects/" + asset.path);
                        if (!file.exists()) {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                        }
                        BufferedInputStream stream = (localMc = new File(DownloadAssetsTask.this.minecraftDir, asset.path)).exists() && Constants.hash(localMc, "SHA1").equals(asset.hash) ? new BufferedInputStream((InputStream)Files.newInputStreamSupplier((File)localMc).getInput()) : new BufferedInputStream(new URL("http://resources.download.minecraft.net/" + asset.path).openStream());
                        Files.write((byte[])ByteStreams.toByteArray((InputStream)stream), (File)file);
                        stream.close();
                        String hash = Constants.hash(file, "SHA1");
                        if (asset.hash.equals(hash)) continue block2;
                        file.delete();
                        DownloadAssetsTask.this.getLogger().error("download attempt " + i + " failed! : " + asset.hash + " != " + hash);
                        continue;
                    }
                    catch (Exception e) {
                        DownloadAssetsTask.this.getLogger().error("Error downloading asset: " + asset.path);
                        e.printStackTrace();
                        if (DownloadAssetsTask.this.errored) continue;
                        DownloadAssetsTask.this.errored = true;
                    }
                }
            }
        }
    }

    private static class Asset {
        public final String path;
        public final String hash;
        public final long size;

        Asset(String hash, long size) {
            this.path = hash.substring(0, 2) + "/" + hash;
            this.hash = hash.toLowerCase();
            this.size = size;
        }
    }
}

