/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.gitver.api.GitVersionConfig;
import net.minecraftforge.gitver.api.GitVersionException;
import net.minecraftforge.gitver.internal.GitVersionInternal;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GitVersion
extends AutoCloseable {
    public static Builder builder() {
        return GitVersionInternal.builder();
    }

    public String getTagOffset();

    public String getTagOffsetBranch();

    public String getTagOffsetBranch(String ... var1);

    public String getTagOffsetBranch(@UnknownNullability Collection<String> var1);

    public String getMCTagOffsetBranch(@UnknownNullability String var1);

    public String getMCTagOffsetBranch(String var1, String ... var2);

    public String getMCTagOffsetBranch(String var1, Collection<String> var2);

    public String generateChangelog(@Nullable String var1, @Nullable String var2, boolean var3) throws GitVersionException;

    public Info getInfo() throws GitVersionException;

    @Nullable
    public String getUrl();

    public String getTagPrefix();

    public @Unmodifiable Collection<String> getFilters();

    public File getGitDir();

    public File getRoot();

    public File getProject();

    public String getProjectPath();

    public String getRelativePath(File var1);

    public String getRelativePath(boolean var1, File var2);

    public @Unmodifiable Collection<File> getIncludes();

    public @Unmodifiable Collection<File> getExcludes();

    public @Unmodifiable Collection<File> getSubprojects();

    @Override
    public void close();

    public String toJson();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder {
        public Builder gitDir(@UnknownNullability File var1);

        public Builder root(@UnknownNullability File var1);

        public Builder project(@UnknownNullability File var1);

        public Builder config(@UnknownNullability File var1);

        public Builder config(GitVersionConfig var1);

        public Builder strict(boolean var1);

        public GitVersion build();
    }

    public static interface Output
    extends Serializable {
        public Info info();

        @Nullable
        public String url();

        @Nullable
        public String gitDirPath();

        @Nullable
        public String rootPath();

        @Nullable
        public String projectPath();

        public List<String> includePaths();

        public List<String> excludePaths();

        @Nullable
        public String tagPrefix();

        public List<String> filters();

        public List<String> subprojectPaths();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @NotNullByDefault
    public static interface Info
    extends Serializable {
        public String getTag();

        public String getOffset();

        public String getHash();

        public String getBranch();

        public String getBranch(boolean var1);

        public String getCommit();

        public String getAbbreviatedId();
    }
}

