/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.gitver.api.GitVersion;
import net.minecraftforge.gitver.api.GitVersionConfig;
import net.minecraftforge.gitver.api.GitVersionException;
import net.minecraftforge.gitver.internal.GitUtils;
import net.minecraftforge.gitver.internal.GitVersionImpl;
import net.minecraftforge.gitver.internal.Util;
import org.eclipse.jgit.util.StringUtils;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

@NotNullByDefault
public interface GitVersionInternal
extends GitVersion {
    public static final List<String> DEFAULT_ALLOWED_BRANCHES = List.of("master", "main", "HEAD");

    public static GitVersion.Builder builder() {
        return new Builder();
    }

    @Override
    default public String getTagOffset() {
        GitVersion.Info info = this.getInfo();
        return "%s.%s".formatted(info.getTag(), info.getOffset());
    }

    @Override
    default public String getTagOffsetBranch() {
        return this.getTagOffsetBranch(DEFAULT_ALLOWED_BRANCHES);
    }

    @Override
    default public String getTagOffsetBranch(String ... allowedBranches) {
        return this.getTagOffsetBranch(Arrays.asList(Util.ensure(allowedBranches)));
    }

    @Override
    default public String getTagOffsetBranch(@UnknownNullability Collection<String> allowedBranches) {
        allowedBranches = Util.ensure(allowedBranches);
        String version = this.getTagOffset();
        if (allowedBranches.isEmpty()) {
            return version;
        }
        String branch = this.getInfo().getBranch(true);
        return StringUtils.isEmptyOrNull((String)branch) || allowedBranches.contains(branch) ? version : "%s-%s".formatted(version, branch);
    }

    @Override
    default public String getMCTagOffsetBranch(@UnknownNullability String mcVersion) {
        if (StringUtils.isEmptyOrNull((String)mcVersion)) {
            return this.getTagOffsetBranch();
        }
        ArrayList<String> allowedBranches = new ArrayList<String>(DEFAULT_ALLOWED_BRANCHES);
        allowedBranches.add(mcVersion);
        allowedBranches.add(mcVersion + ".0");
        allowedBranches.add(mcVersion + ".x");
        allowedBranches.add(mcVersion.substring(0, mcVersion.lastIndexOf(46)) + ".x");
        return this.getMCTagOffsetBranch(mcVersion, allowedBranches);
    }

    @Override
    default public String getMCTagOffsetBranch(String mcVersion, String ... allowedBranches) {
        return this.getMCTagOffsetBranch(mcVersion, Arrays.asList(allowedBranches));
    }

    @Override
    default public String getMCTagOffsetBranch(String mcVersion, Collection<String> allowedBranches) {
        return "%s-%s".formatted(mcVersion, this.getTagOffsetBranch(allowedBranches));
    }

    @Override
    default public String getProjectPath() {
        return GitUtils.getRelativePath(this.getRoot(), this.getProject());
    }

    @Override
    default public String getRelativePath(File file) {
        return this.getRelativePath(false, file);
    }

    @Override
    default public String getRelativePath(boolean fromRoot, File file) {
        return GitUtils.getRelativePath(fromRoot ? this.getRoot() : this.getProject(), file);
    }

    private static File findGitRoot(File from) {
        for (File dir = from.getAbsoluteFile(); dir != null; dir = dir.getParentFile()) {
            if (!GitVersionInternal.isGitRoot(dir)) continue;
            return dir;
        }
        return from;
    }

    private static boolean isGitRoot(File dir) {
        return new File(dir, ".git").exists();
    }

    public @Unmodifiable Collection<String> getIncludesPaths();

    public @Unmodifiable Collection<String> getExcludesPaths();

    public @Unmodifiable Collection<String> getSubprojectPaths();

    @Override
    default public String toJson() {
        return Util.toJson(new Output(this));
    }

    public static final class Builder
    implements GitVersion.Builder {
        @Nullable
        private File gitDir;
        @Nullable
        private File root;
        @Nullable
        private File project;
        @Nullable
        private GitVersionConfig config;
        private boolean strict = true;

        private Builder() {
        }

        @Override
        public GitVersion.Builder gitDir(@UnknownNullability File gitDir) {
            this.gitDir = gitDir;
            return this;
        }

        @Override
        public GitVersion.Builder root(@UnknownNullability File root) {
            this.root = root != null ? root.getAbsoluteFile() : null;
            return this;
        }

        @Override
        public GitVersion.Builder project(@UnknownNullability File project) {
            this.project = project != null ? project.getAbsoluteFile() : null;
            return this;
        }

        @Override
        public GitVersion.Builder config(@UnknownNullability File config) {
            this.config = config != null ? GitVersionConfig.parse(config) : null;
            return this;
        }

        @Override
        public GitVersion.Builder config(GitVersionConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public GitVersion.Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        @Override
        public GitVersion build() {
            if (this.root == null && this.project == null) {
                throw new IllegalArgumentException("Either the root or project directory must be set");
            }
            if (this.root == null) {
                this.root = GitVersionInternal.findGitRoot(this.project);
            }
            if (this.project == null) {
                this.project = this.root;
            }
            if (this.gitDir == null) {
                this.gitDir = new File(this.root, ".git");
            }
            if (this.config == null) {
                File tomlCfg = new File(this.root, ".gitversion.toml");
                File legacyCfg = new File(this.root, ".gitversion");
                this.config = GitVersionConfig.parse(tomlCfg.exists() ? tomlCfg : legacyCfg);
            }
            try {
                if (this.project.compareTo(this.root) > 0 && this.config.getProject(GitUtils.getRelativePath(this.root, this.project)) == null) {
                    File project = this.project.getParentFile();
                    while (project.compareTo(this.root) >= 0) {
                        if (this.config.getProject(GitUtils.getRelativePath(this.root, project)) != null) {
                            this.project = project;
                            break;
                        }
                        project = project.getParentFile();
                    }
                }
                return new GitVersionImpl(this.gitDir, this.root, this.project, this.config, this.strict);
            }
            catch (GitVersionException e) {
                if (!this.strict) {
                    return GitVersionImpl.empty(this.project);
                }
                throw e;
            }
        }
    }

    public record Output(GitVersion.Info info, @Nullable String url, @Nullable String gitDirPath, @Nullable String rootPath, @Nullable String projectPath, List<String> includePaths, List<String> excludePaths, @Nullable String tagPrefix, List<String> filters, List<String> subprojectPaths) implements GitVersion.Output
    {
        public Output(GitVersion.Info info, @Nullable String url, @Nullable File gitDir, @Nullable File root, @Nullable File project, @Nullable Collection<String> includePaths, @Nullable Collection<String> excludePaths, @Nullable String tagPrefix, @Nullable Collection<String> filters, @Nullable Collection<String> subprojectPaths) {
            this(info, url, gitDir != null ? gitDir.getAbsolutePath() : null, root != null ? root.getAbsolutePath() : null, project != null ? project.getAbsolutePath() : null, includePaths != null ? List.copyOf(includePaths) : List.of(), excludePaths != null ? List.copyOf(excludePaths) : List.of(), tagPrefix, filters != null ? List.copyOf(filters) : List.of(), subprojectPaths != null ? List.copyOf(subprojectPaths) : List.of());
        }

        public Output(GitVersionInternal gitVersion) {
            this(gitVersion.getInfo(), gitVersion.getUrl(), Util.tryOrNull(gitVersion::getGitDir), Util.tryOrNull(gitVersion::getRoot), Util.tryOrNull(gitVersion::getProject), Util.tryOrNull(gitVersion::getIncludesPaths), Util.tryOrNull(gitVersion::getExcludesPaths), Util.tryOrNull(gitVersion::getTagPrefix), Util.tryOrNull(gitVersion::getFilters), Util.tryOrNull(gitVersion::getSubprojectPaths));
        }
    }

    @NotNullByDefault
    public static interface Info
    extends GitVersion.Info {
        @Override
        default public String getBranch(boolean versionFriendly) {
            Object branch = this.getBranch();
            if (!versionFriendly || ((String)branch).isBlank()) {
                return branch;
            }
            if (((String)branch).startsWith("pulls/")) {
                branch = "pr" + ((String)branch).substring(((String)branch).lastIndexOf(47) + 1);
            }
            return ((String)branch).replaceAll("[\\\\/]", "-");
        }
    }
}

