/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public final class Util {
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy(Util::readNumber).setPrettyPrinting().create();

    static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    static String[] rsplit(String input, String del, int limit) {
        int index;
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : input.split(del).length);
        int count = 0;
        String tmp = input;
        while ((index = tmp.lastIndexOf(del)) != -1 && (limit == -1 || count++ < limit)) {
            list.add(0, tmp.substring(index + del.length()));
            tmp = tmp.substring(0, index);
        }
        list.add(0, tmp);
        return list.toArray(new String[0]);
    }

    static <T> ArrayList<T> copyList(Collection<T> t, Consumer<? super ArrayList<T>> action) {
        ArrayList<T> list = new ArrayList<T>(t);
        action.accept(list);
        return list;
    }

    static <T> ArrayList<T> toList(Iterable<T> t) {
        ArrayList<T> list = new ArrayList<T>();
        for (T i : t) {
            list.add(i);
        }
        return list;
    }

    static <K, V> HashMap<K, V> removePrefix(Map<K, V> map, String prefix) {
        HashMap ret = new HashMap(map.size());
        map.forEach((k, v) -> {
            String s;
            ret.put(k instanceof String && (s = (String)k).startsWith(prefix) ? s.substring(prefix.length()) : k, v instanceof String && (s = (String)v).startsWith(prefix) ? s.substring(prefix.length()) : v);
        });
        return ret;
    }

    static int count(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            return c.size();
        }
        int count = -1;
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    @Nullable
    static <T> T findFirst(@Nullable Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
            T t = iterator.next();
            return t;
        }
        return null;
    }

    static int indexOf(String s, CharPredicate matcher, int orElse) {
        for (char c : s.toCharArray()) {
            if (!matcher.test(c)) continue;
            return s.indexOf(c);
        }
        return orElse;
    }

    @Nullable
    static <T> T findFirst(Iterable<T> iterable, Predicate<T> filter) {
        for (T t : iterable) {
            if (!filter.test(t)) continue;
            return t;
        }
        return null;
    }

    static <T> boolean forEach(Iterable<T> iterable, Consumer<T> action) {
        Iterator<T> it = iterable.iterator();
        if (!it.hasNext()) {
            return false;
        }
        it.forEachRemaining(action);
        return true;
    }

    static <T> T make(Supplier<T> t) {
        return t.get();
    }

    static <T> T make(T t, Consumer<T> action) {
        if (t != null) {
            action.accept(t);
        }
        return t;
    }

    @Nullable
    static String replace(@Nullable String s, UnaryOperator<String> action) {
        return s != null ? (String)action.apply(s) : s;
    }

    static <T> T orElse(T t, Supplier<T> ifEmptyOrNull) {
        return t != null && !t.equals("") ? t : ifEmptyOrNull.get();
    }

    static String[] ensure(String[] array) {
        return array != null ? array : new String[]{};
    }

    public static <T> Collection<T> ensure(@Nullable Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    @Nullable
    public static <T> T tryOrNull(Callable<@Nullable T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Number readNumber(JsonReader in) throws IOException {
        try {
            return ToNumberPolicy.LONG_OR_DOUBLE.readNumber(in);
        }
        catch (Throwable suppressed) {
            try {
                return ToNumberPolicy.BIG_DECIMAL.readNumber(in);
            }
            catch (Throwable e) {
                IOException throwing = new IOException("Failed to read number from " + String.valueOf(in), e);
                throwing.addSuppressed(suppressed);
                throw throwing;
            }
        }
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    @FunctionalInterface
    static interface CharPredicate {
        public boolean test(char var1);
    }
}

