/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.gitver.api.GitVersionConfig;
import net.minecraftforge.gitver.internal.GitVersionConfigInternal;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;
import org.tomlj.TomlVersion;

@NotNullByDefault
public record GitVersionConfigImpl(Map<String, GitVersionConfig.Project> projects, List<? extends RuntimeException> errors) implements GitVersionConfigInternal
{
    static final GitVersionConfig EMPTY = new Empty();

    @Override
    @Nullable
    public GitVersionConfig.Project getProject(@Nullable String path) {
        return this.projects.get(path);
    }

    @Override
    public Collection<GitVersionConfig.Project> getAllProjects() {
        return this.projects.values();
    }

    @Override
    public void validate(File root) {
        for (String path : this.projects.keySet()) {
            if (path.isEmpty() || new File(root, path).exists()) continue;
            throw new IllegalArgumentException("Subproject path '%s' does not exist. Specify it explicitly in the config if necessary.".formatted(path));
        }
    }

    public static GitVersionConfig parse(@UnknownNullability File config) throws IOException {
        if (config == null || !config.exists()) {
            return EMPTY;
        }
        TomlParseResult toml = Toml.parse(config.toPath(), TomlVersion.V1_0_0);
        Set<String> keys = toml.keySet();
        if (keys.contains("")) {
            throw new IllegalArgumentException("Config file cannot have a table with an empty string ([\"\"]), use [root] instead.");
        }
        HashMap<String, GitVersionConfig.Project> projects = new HashMap<String, GitVersionConfig.Project>(keys.size() + 1);
        projects.put("", ProjectImpl.parse(toml));
        for (String key : keys) {
            if ("root".equals(key) || !toml.isTable(key)) continue;
            GitVersionConfig.Project project = ProjectImpl.parse(key, toml.getTable(key));
            projects.put(project.getPath(), project);
        }
        return new GitVersionConfigImpl(projects, toml.errors());
    }

    public record ProjectImpl(String getPath, String getTagPrefix, String[] getFilters) implements GitVersionConfigInternal.Project
    {
        private static final ProjectImpl DEFAULT_ROOT = new ProjectImpl("", "", new String[0]);
        private static final List<GitVersionConfig.Project> DEFAULT_ROOT_LIST = List.of(DEFAULT_ROOT);

        private static GitVersionConfig.Project parse(TomlParseResult toml) {
            TomlTable root = toml.getTableOrEmpty("root");
            if (root.isEmpty()) {
                return DEFAULT_ROOT;
            }
            String tagPrefix = root.contains("tag") ? root.getString("tag") : "";
            String[] filters = (String[])root.getArrayOrEmpty("filters").toList().stream().map(String.class::cast).filter(s -> !s.isBlank()).toArray(String[]::new);
            return new ProjectImpl("", tagPrefix, filters);
        }

        private static GitVersionConfig.Project parse(String key, TomlTable table) {
            String project = Objects.requireNonNullElse(table.getString("path"), key);
            String tagPrefix = table.contains("tag") ? table.getString("tag") : project.replace("/", "-");
            String[] filters = (String[])table.getArrayOrEmpty("filters").toList().stream().map(String.class::cast).filter(s -> !s.isBlank()).toArray(String[]::new);
            return new ProjectImpl(project, tagPrefix, filters);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof ProjectImpl)) return false;
            ProjectImpl p = (ProjectImpl)o;
            if (!Objects.equals(this.getPath, p.getPath)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getPath);
        }
    }

    public static final class Empty
    implements GitVersionConfigInternal {
        private Empty() {
        }

        @Override
        @Nullable
        public GitVersionConfigInternal.Project getProject(@Nullable String path) {
            return path != null && path.isEmpty() ? ProjectImpl.DEFAULT_ROOT : null;
        }

        @Override
        public Collection<GitVersionConfig.Project> getAllProjects() {
            return ProjectImpl.DEFAULT_ROOT_LIST;
        }

        @Override
        public void validate(@UnknownNullability File root) {
        }

        @Override
        public List<? extends RuntimeException> errors() {
            return List.of();
        }
    }
}

