/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public interface Util {
    public static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    public static String[] rsplit(String input, String del, int limit) {
        int index;
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : input.split(del).length);
        int count = 0;
        String tmp = input;
        while ((index = tmp.lastIndexOf(del)) != -1 && (limit == -1 || count++ < limit)) {
            list.add(0, tmp.substring(index + del.length()));
            tmp = tmp.substring(0, index);
        }
        list.add(0, tmp);
        return list.toArray(new String[0]);
    }

    public static <T> ArrayList<T> copyList(Collection<T> t, Consumer<? super ArrayList<T>> action) {
        ArrayList<T> list = new ArrayList<T>(t);
        action.accept(list);
        return list;
    }

    public static <T> ArrayList<T> toList(Iterable<T> t) {
        ArrayList<T> list = new ArrayList<T>();
        for (T i : t) {
            list.add(i);
        }
        return list;
    }

    public static <K, V> HashMap<K, V> removePrefix(Map<K, V> map, String prefix) {
        HashMap ret = new HashMap(map.size());
        map.forEach((k, v) -> {
            String s;
            ret.put(k instanceof String && (s = (String)k).startsWith(prefix) ? s.substring(prefix.length()) : k, v instanceof String && (s = (String)v).startsWith(prefix) ? s.substring(prefix.length()) : v);
        });
        return ret;
    }

    public static int count(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            return c.size();
        }
        int count = -1;
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    @Nullable
    public static <T> T findFirst(@Nullable Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
            T t = iterator.next();
            return t;
        }
        return null;
    }

    public static int indexOf(String s, CharPredicate matcher, int orElse) {
        for (char c : s.toCharArray()) {
            if (!matcher.test(c)) continue;
            return s.indexOf(c);
        }
        return orElse;
    }

    @Nullable
    public static <T> T findFirst(Iterable<T> iterable, Predicate<T> filter) {
        for (T t : iterable) {
            if (!filter.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean forEach(Iterable<T> iterable, Consumer<T> action) {
        Iterator<T> it = iterable.iterator();
        if (!it.hasNext()) {
            return false;
        }
        it.forEachRemaining(action);
        return true;
    }

    public static <T> T make(Supplier<T> t) {
        return t.get();
    }

    public static <T> T make(T t, Consumer<T> action) {
        if (t != null) {
            action.accept(t);
        }
        return t;
    }

    @Nullable
    public static String replace(@Nullable String s, UnaryOperator<String> action) {
        return s != null ? (String)action.apply(s) : s;
    }

    public static <T> T orElse(T t, Supplier<T> ifEmptyOrNull) {
        return t != null && !t.equals("") ? t : ifEmptyOrNull.get();
    }

    public static String[] ensure(String[] array) {
        return array != null ? array : new String[]{};
    }

    public static <T> Collection<T> ensure(@Nullable Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    @FunctionalInterface
    public static interface CharPredicate {
        public boolean test(char var1);
    }
}

