/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.api;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraftforge.gitver.api.GitVersionConfig;
import net.minecraftforge.gitver.api.GitVersionException;
import net.minecraftforge.gitver.internal.GitUtils;
import net.minecraftforge.gitver.internal.GitVersionImpl;
import net.minecraftforge.gitver.internal.Util;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.UnmodifiableView;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GitVersion
extends AutoCloseable {
    public static Builder builder() {
        return new Builder();
    }

    default public String getTagOffset() {
        Info info = this.getInfo();
        return "%s.%s".formatted(info.getTag(), info.getOffset());
    }

    default public String getTagOffsetBranch() {
        return this.getTagOffsetBranch(GitUtils.DEFAULT_ALLOWED_BRANCHES);
    }

    default public String getTagOffsetBranch(String ... allowedBranches) {
        return this.getTagOffsetBranch(Arrays.asList(Util.ensure(allowedBranches)));
    }

    default public String getTagOffsetBranch(@UnknownNullability Collection<String> allowedBranches) {
        allowedBranches = Util.ensure(allowedBranches);
        String version = this.getTagOffset();
        if (allowedBranches.isEmpty()) {
            return version;
        }
        String branch = this.getInfo().getBranch(true);
        return StringUtils.isEmptyOrNull((String)branch) || allowedBranches.contains(branch) ? version : "%s-%s".formatted(version, branch);
    }

    default public String getMCTagOffsetBranch(@UnknownNullability String mcVersion) {
        if (StringUtils.isEmptyOrNull((String)mcVersion)) {
            return this.getTagOffsetBranch();
        }
        ArrayList<String> allowedBranches = new ArrayList<String>(GitUtils.DEFAULT_ALLOWED_BRANCHES);
        allowedBranches.add(mcVersion);
        allowedBranches.add(mcVersion + ".0");
        allowedBranches.add(mcVersion + ".x");
        allowedBranches.add(mcVersion.substring(0, mcVersion.lastIndexOf(46)) + ".x");
        return this.getMCTagOffsetBranch(mcVersion, allowedBranches);
    }

    default public String getMCTagOffsetBranch(String mcVersion, String ... allowedBranches) {
        return this.getMCTagOffsetBranch(mcVersion, Arrays.asList(allowedBranches));
    }

    default public String getMCTagOffsetBranch(String mcVersion, Collection<String> allowedBranches) {
        return "%s-%s".formatted(mcVersion, this.getTagOffsetBranch(allowedBranches));
    }

    public String generateChangelog(@Nullable String var1, @Nullable String var2, boolean var3) throws GitVersionException;

    public Info getInfo() throws GitVersionException;

    @Nullable
    public String getUrl();

    public String getTagPrefix();

    @Deprecated
    default public void setTagPrefix(String tagPrefix) {
    }

    public @UnmodifiableView Collection<String> getFilters();

    default public void setFilters(Collection<String> filters) {
        this.setFilters(filters.toArray(new String[0]));
    }

    @Deprecated
    default public void setFilters(String ... filters) {
    }

    public File getGitDir();

    public File getRoot();

    public File getProject();

    default public String getProjectPath() {
        return GitUtils.getRelativePath(this.getRoot(), this.getProject());
    }

    default public String getRelativePath(File file) {
        return this.getRelativePath(false, file);
    }

    default public String getRelativePath(boolean fromRoot, File file) {
        return GitUtils.getRelativePath(fromRoot ? this.getRoot() : this.getProject(), file);
    }

    public static File findGitRoot(File from) {
        for (File dir = from.getAbsoluteFile(); dir != null; dir = dir.getParentFile()) {
            if (!GitVersion.isGitRoot(dir)) continue;
            return dir;
        }
        return from;
    }

    public static boolean isGitRoot(File dir) {
        return new File(dir, ".git").exists();
    }

    @Deprecated(forRemoval=true)
    public static String findRelativePath(File file) {
        return GitUtils.getRelativePath(GitVersion.findGitRoot(file), file);
    }

    public @UnmodifiableView Collection<File> getSubprojects();

    default public Collection<String> getSubprojectPaths() {
        return this.getSubprojectPaths(false);
    }

    default public Collection<String> getSubprojectPaths(boolean fromRoot) {
        return this.getSubprojects().stream().map(dir -> GitUtils.getRelativePath(fromRoot ? this.getRoot() : this.getProject(), dir)).filter(s -> !s.isBlank()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void close();

    @ApiStatus.Experimental
    public static void disableSystemConfig() {
        SystemReader.setInstance((SystemReader)new SystemReader.Delegate(SystemReader.getInstance()){

            public FileBasedConfig openSystemConfig(Config parent, FS fs) {
                return new FileBasedConfig(parent, null, fs){

                    public void load() {
                    }

                    public boolean isOutdated() {
                        return false;
                    }
                };
            }
        });
    }

    public static void restoreSystemReader() {
        SystemReader.setInstance(null);
    }

    public static final class Builder {
        @Nullable
        private File gitDir;
        @Nullable
        private File root;
        @Nullable
        private File project;
        @Nullable
        private GitVersionConfig config;
        private boolean strict = true;

        private Builder() {
        }

        public Builder gitDir(File gitDir) {
            this.gitDir = gitDir;
            return this;
        }

        public Builder root(@UnknownNullability File root) {
            this.root = root != null ? root.getAbsoluteFile() : null;
            return this;
        }

        public Builder project(@UnknownNullability File project) {
            this.project = project != null ? project.getAbsoluteFile() : null;
            return this;
        }

        public Builder config(@UnknownNullability File config) {
            this.config = config != null ? GitVersionConfig.parse(config) : null;
            return this;
        }

        public Builder config(GitVersionConfig config) {
            this.config = config;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public GitVersion build() {
            if (this.root == null && this.project == null) {
                throw new IllegalArgumentException("Either the root or project directory must be set");
            }
            if (this.root == null) {
                this.root = GitVersion.findGitRoot(this.project);
            }
            if (this.project == null) {
                this.project = this.root;
            }
            if (this.gitDir == null) {
                this.gitDir = new File(this.root, ".git");
            }
            if (this.config == null) {
                this.config = GitVersionConfig.parse(new File(this.root, ".gitversion"));
            }
            try {
                return new GitVersionImpl(this.gitDir, this.root, this.project, this.config, this.strict);
            }
            catch (GitVersionException e) {
                if (!this.strict) {
                    return GitVersionImpl.emptyFor(this.project);
                }
                throw e;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @NotNullByDefault
    public static interface Info
    extends Serializable {
        public String getTag();

        public String getOffset();

        public String getHash();

        public String getBranch();

        default public String getBranch(boolean versionFriendly) {
            Object branch = this.getBranch();
            if (!versionFriendly || ((String)branch).isBlank()) {
                return branch;
            }
            if (((String)branch).startsWith("pulls/")) {
                branch = "pr" + ((String)branch).substring(((String)branch).lastIndexOf(47) + 1);
            }
            return ((String)branch).replaceAll("[\\\\/]", "-");
        }

        public String getCommit();

        public String getAbbreviatedId();
    }
}

