/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitver.cli;

import java.io.File;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.gitver.api.GitVersion;
import org.jetbrains.annotations.Nullable;

public final class Main {
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec help0 = parser.accepts("help", "Displays this help message and exits").forHelp();
        OptionSpecBuilder disableStrict0 = parser.accepts("disable-strict", "Disables strict mode, allowing GitVersion to continue even if an error occurs.\nVersion numbers will be set to default values (i.e. 0.0.0), and generated changelogs will be completely empty.");
        ArgumentAcceptingOptionSpec<File> configFile0 = parser.accepts("config-file", "The config file to read from.\nIf unspecified, Git Version will attempt to locate this as '.gitversion' in the root directory.\nIf the file does not exist, the default behavior is assumed and there will be no subprojects.\nUnless manually specified, the containing folder will be the project directory, and read access is required.").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> gitDir0 = parser.accepts("git-dir", "The git directory to use.\nIf unspecified, Git Version will attempt to locate this automatically.").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> rootDir0 = parser.accepts("root-dir", "The root directory to use (ideally containing the .git directory).\nIf unspecified, Git Version will attempt to locate this automatically.").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> projectDir0 = parser.accepts("project-dir", "The project directory to use. (default: .)").withOptionalArg().ofType(File.class).defaultsTo(new File("."), (File[])new File[0]);
        OptionSet options = parser.parse(args);
        if (options.has(help0)) {
            System.out.println("Git Version");
            parser.printHelpOn(System.out);
            return;
        }
        boolean strict = !options.has(disableStrict0);
        File configFile = options.valueOf(configFile0);
        File projectDir = options.valueOf(projectDir0);
        File rootDir = options.valueOf(rootDir0);
        File gitDir = options.valueOf(gitDir0);
        try (GitVersion version = GitVersion.builder().gitDir(gitDir).root(rootDir).project(projectDir).config(configFile).strict(strict).build();){
            System.out.print(version.getTagOffset());
        }
    }

    private static boolean canWrite(File file) {
        return file.canWrite() || !file.exists() && file.getParentFile().canWrite();
    }

    @Nullable
    private static OptionSet tryParse(OptionParser parser, String[] args) {
        try {
            return parser.parse(args);
        }
        catch (OptionException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

