/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitversion.gradle.changelog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import net.minecraftforge.gitversion.gradle.GitVersionTools;
import net.minecraftforge.gitversion.gradle.changelog.ChangelogProblems;
import net.minecraftforge.gitversion.gradle.changelog.Util;
import net.minecraftforge.gradleutils.shared.ToolExecBase;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public abstract class GenerateChangelog
extends ToolExecBase<ChangelogProblems> {
    public static final String NAME = "createChangelog";

    @Inject
    public GenerateChangelog() {
        super(ChangelogProblems.class, GitVersionTools.GITVERSION);
        this.setDescription("Generates a changelog for the project based on the Git history using Git Version.");
        this.getOutputFile().convention(this.getProjectLayout().getBuildDirectory().file("changelog.txt").map(((ChangelogProblems)this.getProblems()).ensureFileLocation()));
        this.getProjectPath().convention(this.getProviderFactory().provider(() -> this.getProjectLayout().getProjectDirectory().getAsFile().getAbsolutePath()));
        this.getBuildMarkdown().convention((Object)false);
    }

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    protected abstract Property<String> getProjectPath();

    @Input
    @Optional
    public abstract Property<String> getStart();

    @Input
    @Optional
    public abstract Property<String> getProjectUrl();

    @Input
    public abstract Property<Boolean> getBuildMarkdown();

    protected void addArguments() {
        super.addArguments();
        this.args(new Object[]{"--changelog", "--project-dir", this.getProjectPath().get()});
        if (this.getStart().isPresent()) {
            this.args(new Object[]{"--start", this.getStart().get()});
        }
        if (this.getProjectUrl().isPresent()) {
            this.args(new Object[]{"--url", this.getProjectUrl().get()});
        }
        if (!((Boolean)this.getBuildMarkdown().getOrElse((Object)false)).booleanValue()) {
            this.args(new Object[]{"--plain-text"});
        }
    }

    public void exec() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.setStandardOutput(output);
        this.setErrorOutput(Util.toLog(arg_0 -> ((Logger)this.getLogger()).error(arg_0)));
        super.exec();
        try {
            Files.writeString(((RegularFile)this.getOutputFile().get()).getAsFile().toPath(), (CharSequence)output.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

