/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitversion.gradle;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.gitver.internal.Util;
import net.minecraftforge.gitversion.gradle.GitVersionExtension;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@NotNullByDefault
interface GitVersionExtensionInternal
extends GitVersionExtension,
HasPublicType {
    public static final List<String> DEFAULT_ALLOWED_BRANCHES = List.of("master", "main", "HEAD");

    default public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GitVersionExtension.class);
    }

    @Override
    default public String getTagOffset() {
        GitVersionExtension.Info info = this.getInfo();
        return "%s.%s".formatted(info.getTag(), info.getOffset());
    }

    @Override
    default public String getTagOffsetBranch() {
        return this.getTagOffsetBranch(DEFAULT_ALLOWED_BRANCHES);
    }

    @Override
    default public String getTagOffsetBranch(String ... allowedBranches) {
        return this.getTagOffsetBranch(Arrays.asList(allowedBranches != null ? allowedBranches : new String[]{}));
    }

    @Override
    default public String getTagOffsetBranch(@UnknownNullability Collection<String> allowedBranches) {
        allowedBranches = Util.ensure(allowedBranches);
        String version = this.getTagOffset();
        if (allowedBranches.isEmpty()) {
            return version;
        }
        String branch = this.getInfo().getBranch(true);
        return branch.isBlank() || allowedBranches.contains(branch) ? version : "%s-%s".formatted(version, branch);
    }

    @Override
    default public String getMCTagOffsetBranch(@UnknownNullability String mcVersion) {
        if (mcVersion == null || mcVersion.isBlank()) {
            return this.getTagOffsetBranch();
        }
        ArrayList<String> allowedBranches = new ArrayList<String>(DEFAULT_ALLOWED_BRANCHES);
        allowedBranches.add(mcVersion);
        allowedBranches.add(mcVersion + ".0");
        allowedBranches.add(mcVersion + ".x");
        allowedBranches.add(mcVersion.substring(0, mcVersion.lastIndexOf(46)) + ".x");
        return this.getMCTagOffsetBranch(mcVersion, allowedBranches);
    }

    @Override
    default public String getMCTagOffsetBranch(String mcVersion, String ... allowedBranches) {
        return this.getMCTagOffsetBranch(mcVersion, Arrays.asList(allowedBranches));
    }

    @Override
    default public String getMCTagOffsetBranch(String mcVersion, Collection<String> allowedBranches) {
        return "%s-%s".formatted(mcVersion, this.getTagOffsetBranch(allowedBranches));
    }

    private static String getRelativePath(File root, File file) {
        if (root.equals(file)) {
            return "";
        }
        return GitVersionExtensionInternal.getRelativePath(root.toPath(), file.toPath());
    }

    private static String getRelativePath(Path root, Path path) {
        return root.relativize(path).toString().replace(root.getFileSystem().getSeparator(), "/");
    }

    @Override
    default public String getProjectPath() {
        return GitVersionExtensionInternal.getRelativePath(this.getRoot().getAsFile(), this.getProject().getAsFile());
    }

    @Override
    default public String getRelativePath(File file) {
        return this.getRelativePath(false, file);
    }

    @Override
    default public String getRelativePath(boolean fromRoot, File file) {
        return GitVersionExtensionInternal.getRelativePath(fromRoot ? this.getRoot().getAsFile() : this.getProject().getAsFile(), file);
    }

    public record Output(Info info, @Nullable String url, @Nullable String gitDirPath, @Nullable String rootPath, @Nullable String projectPath, @Nullable String tagPrefix, List<String> filters, List<String> subprojectPaths) implements Serializable
    {
    }

    @NotNullByDefault
    public record Info(String getTag, String getOffset, String getHash, String getBranch, String getCommit, String getAbbreviatedId) implements GitVersionExtension.Info
    {
        @Override
        public String getBranch(boolean versionFriendly) {
            Object branch = this.getBranch();
            if (!versionFriendly || ((String)branch).isBlank()) {
                return branch;
            }
            if (((String)branch).startsWith("pulls/")) {
                branch = "pr" + ((String)branch).substring(((String)branch).lastIndexOf(47) + 1);
            }
            return ((String)branch).replaceAll("[\\\\/]", "-");
        }
    }
}

