/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gitversion.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GitVersionExtension {
    public static final String NAME = "gitversion";

    public String getTagOffset();

    public String getTagOffsetBranch();

    public String getTagOffsetBranch(String ... var1);

    public String getTagOffsetBranch(@UnknownNullability Collection<String> var1);

    public String getMCTagOffsetBranch(@UnknownNullability String var1);

    public String getMCTagOffsetBranch(String var1, String ... var2);

    public String getMCTagOffsetBranch(String var1, Collection<String> var2);

    public Info getInfo();

    @Nullable
    public String getUrl();

    public String getTagPrefix();

    public @Unmodifiable Collection<String> getFilters();

    public Directory getGitDir();

    public Directory getRoot();

    public Directory getProject();

    public String getProjectPath();

    default public Provider<String> getRelativePath(FileSystemLocationProperty<?> file) {
        return this.getRelativePath((Provider<? extends FileSystemLocation>)file.getLocationOnly());
    }

    default public Provider<String> getRelativePath(Provider<? extends FileSystemLocation> file) {
        return file.map(FileSystemLocation::getAsFile).map(this::getRelativePath);
    }

    default public String getRelativePath(FileSystemLocation file) {
        return this.getRelativePath(file.getAsFile());
    }

    public String getRelativePath(File var1);

    default public Provider<String> getRelativePath(boolean fromRoot, FileSystemLocationProperty<?> file) {
        return this.getRelativePath(fromRoot, (Provider<? extends FileSystemLocation>)file.getLocationOnly());
    }

    default public Provider<String> getRelativePath(boolean fromRoot, Provider<? extends FileSystemLocation> file) {
        return file.map(f -> this.getRelativePath(fromRoot, f.getAsFile()));
    }

    default public String getRelativePath(boolean fromRoot, FileSystemLocation file) {
        return this.getRelativePath(fromRoot, file.getAsFile());
    }

    public String getRelativePath(boolean var1, File var2);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @NotNullByDefault
    public static interface Info
    extends Serializable {
        public String getTag();

        public String getOffset();

        public String getHash();

        public String getBranch();

        public String getBranch(boolean var1);

        public String getCommit();

        public String getAbbreviatedId();
    }
}

