/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class StaticVersionComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 6082715929370009879L;
    static final StaticVersionComparator INSTANCE = new StaticVersionComparator();
    static final Map<String, Integer> SPECIAL_MEANINGS = Map.of("dev", -1, "rc", 1, "snapshot", 2, "final", 3, "ga", 4, "release", 5, "sp", 6);

    StaticVersionComparator() {
    }

    @Override
    public int compare(String o1, String o2) {
        return StaticVersionComparator.compareNow(o1, o2);
    }

    static int compareNow(String o1, String o2) {
        return StaticVersionComparator.compare(Version.parse(o1), Version.parse(o2));
    }

    private static int compare(Version version1, Version version2) {
        int i;
        if (version1.equals(version2)) {
            return 0;
        }
        String[] parts1 = version1.getParts();
        String[] parts2 = version2.getParts();
        Long[] numericParts1 = version1.getNumericParts();
        Long[] numericParts2 = version2.getNumericParts();
        for (i = 0; i < parts1.length && i < parts2.length; ++i) {
            boolean is2Number;
            String part1 = parts1[i];
            String part2 = parts2[i];
            Long numericPart1 = numericParts1[i];
            Long numericPart2 = numericParts2[i];
            boolean is1Number = numericPart1 != null;
            boolean bl = is2Number = numericPart2 != null;
            if (part1.equals(part2)) continue;
            if (is1Number && !is2Number) {
                return 1;
            }
            if (is2Number && !is1Number) {
                return -1;
            }
            if (is1Number && is2Number) {
                int result = numericPart1.compareTo(numericPart2);
                if (result == 0) continue;
                return result;
            }
            Integer sm1 = SPECIAL_MEANINGS.get(part1.toLowerCase(Locale.US));
            Integer sm2 = SPECIAL_MEANINGS.get(part2.toLowerCase(Locale.US));
            if (sm1 != null) {
                sm2 = sm2 == null ? 0 : sm2;
                return sm1 - sm2;
            }
            if (sm2 != null) {
                return -sm2.intValue();
            }
            return part1.compareTo(part2);
        }
        if (i < parts1.length) {
            return numericParts1[i] == null ? -1 : 1;
        }
        if (i < parts2.length) {
            return numericParts2[i] == null ? 1 : -1;
        }
        return 0;
    }

    private static interface Version {
        public String getSource();

        public String[] getParts();

        public Long[] getNumericParts();

        public Version getBaseVersion();

        public boolean isQualified();

        public static Version parse(String original) {
            int pos;
            ArrayList<String> parts = new ArrayList<String>();
            boolean digit = false;
            int startPart = 0;
            int endBase = 0;
            int endBaseStr = 0;
            for (pos = 0; pos < original.length(); ++pos) {
                char ch = original.charAt(pos);
                if (ch == '.' || ch == '_' || ch == '-' || ch == '+') {
                    parts.add(original.substring(startPart, pos));
                    startPart = pos + 1;
                    digit = false;
                    if (ch == '.' || endBaseStr != 0) continue;
                    endBase = parts.size();
                    endBaseStr = pos;
                    continue;
                }
                if (ch >= '0' && ch <= '9') {
                    if (!digit && pos > startPart) {
                        if (endBaseStr == 0) {
                            endBase = parts.size() + 1;
                            endBaseStr = pos;
                        }
                        parts.add(original.substring(startPart, pos));
                        startPart = pos;
                    }
                    digit = true;
                    continue;
                }
                if (digit) {
                    if (endBaseStr == 0) {
                        endBase = parts.size() + 1;
                        endBaseStr = pos;
                    }
                    parts.add(original.substring(startPart, pos));
                    startPart = pos;
                }
                digit = false;
            }
            if (pos > startPart) {
                parts.add(original.substring(startPart, pos));
            }
            DefaultVersion base = null;
            if (endBaseStr > 0) {
                base = new DefaultVersion(original.substring(0, endBaseStr), parts.subList(0, endBase), null);
            }
            return new DefaultVersion(original, parts, base);
        }
    }

    private static class DefaultVersion
    implements Version {
        private final String source;
        private final String[] parts;
        private final Long[] numericParts;
        private final DefaultVersion baseVersion;

        public DefaultVersion(String source, List<String> parts, DefaultVersion baseVersion) {
            this.source = source;
            this.parts = parts.toArray(new String[0]);
            this.numericParts = new Long[this.parts.length];
            for (int i = 0; i < parts.size(); ++i) {
                Long part = null;
                try {
                    part = Long.parseLong(this.parts[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.numericParts[i] = part;
            }
            this.baseVersion = baseVersion == null ? this : baseVersion;
        }

        public String toString() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DefaultVersion other = (DefaultVersion)obj;
            return this.source.equals(other.source);
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        @Override
        public boolean isQualified() {
            return this.baseVersion != this;
        }

        @Override
        public Version getBaseVersion() {
            return this.baseVersion;
        }

        @Override
        public String[] getParts() {
            return this.parts;
        }

        @Override
        public Long[] getNumericParts() {
            return this.numericParts;
        }

        @Override
        public String getSource() {
            return this.source;
        }
    }
}

