/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.SlimeLauncherOptionsNested;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsInternal;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class SlimeLauncherOptionsImpl
implements SlimeLauncherOptionsInternal {
    private static final LogLevel level = LogLevel.INFO;
    private final String name;
    private final Property<String> mainClass = this.getObjects().property(String.class);
    private final Property<Boolean> inheritArgs = this.getObjects().property(Boolean.class);
    private final ListProperty<String> args = this.getObjects().listProperty(String.class);
    private final Property<Boolean> inheritJvmArgs = this.getObjects().property(Boolean.class);
    private final ListProperty<String> jvmArgs = this.getObjects().listProperty(String.class);
    private final ConfigurableFileCollection classpath = this.getObjects().fileCollection();
    private final Property<String> minHeapSize = this.getObjects().property(String.class);
    private final Property<String> maxHeapSize = this.getObjects().property(String.class);
    private final MapProperty<String, String> systemProperties = this.getObjects().mapProperty(String.class, String.class);
    private final MapProperty<String, String> environment = this.getObjects().mapProperty(String.class, String.class);
    private final DirectoryProperty workingDir = this.getObjects().directoryProperty();
    private final Property<Boolean> client = this.getObjects().property(Boolean.class).convention((Object)false);
    private final MapProperty<String, SlimeLauncherOptionsNested> nested = this.getObjects().mapProperty(String.class, SlimeLauncherOptionsNested.class);

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public SlimeLauncherOptionsImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    public Property<Boolean> getInheritArgs() {
        return this.inheritArgs;
    }

    @Override
    public ListProperty<String> getArgs() {
        return this.args;
    }

    @Override
    public Property<Boolean> getInheritJvmArgs() {
        return this.inheritJvmArgs;
    }

    @Override
    public ListProperty<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public Property<String> getMinHeapSize() {
        return this.minHeapSize;
    }

    @Override
    public Property<String> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Override
    public MapProperty<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public MapProperty<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public DirectoryProperty getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public Property<Boolean> getClient() {
        return this.client;
    }

    @Override
    public MapProperty<String, SlimeLauncherOptionsNested> getNested() {
        return this.nested;
    }

    @Override
    public void with(String sourceSetName, Action<? super SlimeLauncherOptionsNested> action) {
        SlimeLauncherOptionsImpl child = (SlimeLauncherOptionsImpl)this.getObjects().newInstance(SlimeLauncherOptionsImpl.class, new Object[]{this.name});
        action.execute((Object)child);
        this.getNested().put((Object)sourceSetName, (Object)child);
    }

    @Override
    public void args(Object args) {
        this.getArgs().add(this.getProviders().provider(() -> Util.unpack(args).toString()));
    }

    @Override
    public void args(Object ... args) {
        this.getArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>(args.length);
            for (Object arg : args) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void args(Iterable<?> args) {
        this.getArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : args) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void args(Provider<? extends Iterable<?>> args) {
        this.getArgs().addAll(args.map(iterable -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : iterable) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void setArgs(String ... args) {
        this.getArgs().set(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (String arg : args) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void jvmArgs(Object jvmArgs) {
        this.getJvmArgs().add(this.getProviders().provider(() -> Util.unpack(jvmArgs).toString()));
    }

    @Override
    public void jvmArgs(Object ... jvmArgs) {
        this.getJvmArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : jvmArgs) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void jvmArgs(Iterable<?> jvmArgs) {
        this.getJvmArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : jvmArgs) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void jvmArgs(Provider<? extends Iterable<?>> jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs.map(iterable -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : iterable) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void setJvmArgs(Object ... jvmArgs) {
        this.getJvmArgs().set(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : jvmArgs) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, this.getProviders().provider(() -> Util.unpack(value).toString()));
    }

    @Override
    public void systemProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.getSystemProperties().put((Object)entry.getKey(), this.getProviders().provider(() -> Util.unpack(entry.getValue()).toString()));
        }
    }

    @Override
    public void systemProperties(Provider<? extends Map<String, ?>> properties) {
        this.getSystemProperties().putAll(properties.map(map -> {
            HashMap<String, String> ret = new HashMap<String, String>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ret.put((String)entry.getKey(), Util.unpack(entry.getValue()).toString());
            }
            return ret;
        }));
    }

    @Override
    public void environment(String name, Object value) {
        this.getSystemProperties().put((Object)name, this.getProviders().provider(() -> Util.unpack(value).toString()));
    }

    @Override
    public void environment(Map<String, ?> environment) {
        for (Map.Entry<String, ?> entry : environment.entrySet()) {
            this.getEnvironment().put((Object)entry.getKey(), this.getProviders().provider(() -> Util.unpack(entry.getValue()).toString()));
        }
    }

    @Override
    public void environment(Provider<? extends Map<String, ?>> properties) {
        this.getEnvironment().putAll(properties.map(map -> {
            HashMap<String, String> ret = new HashMap<String, String>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ret.put((String)entry.getKey(), Util.unpack(entry.getValue()).toString());
            }
            return ret;
        }));
    }

    @Override
    public SlimeLauncherOptionsInternal inherit(Map<String, RunConfig> configs, String sourceSetName, String name) {
        SlimeLauncherOptionsNested child;
        LOGGER.log(level, "Baking Launch Options: {} for sourceset {}", new Object[]{name, sourceSetName});
        SlimeLauncherOptionsImpl target = (SlimeLauncherOptionsImpl)this.getObjects().newInstance(SlimeLauncherOptionsImpl.class, new Object[]{name});
        target.getWorkingDir().set((Object)this.getProjectLayout().getProjectDirectory().dir("runs/" + sourceSetName + "/" + this.name));
        target.getClasspath().setFrom((Iterable)this.getClasspath());
        LOGGER.log(level, "Inheriting Json Parent {}", new Object[]{name});
        target.inheritFromJson("  ", configs, name);
        LOGGER.log(level, "Inheriting From Self");
        target.inherit(this);
        if (this.getClient().isPresent() && ((Boolean)this.getClient().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
            LOGGER.log(level, "  Client: {}", new Object[]{this.getClient().get()});
            target.getClient().set((Object)((Boolean)this.getClient().get()));
        }
        if ((child = (SlimeLauncherOptionsNested)this.getNested().getting((Object)sourceSetName).getOrNull()) != null) {
            LOGGER.log(level, "Inheriting from Child");
            target.inherit(child);
        }
        return target;
    }

    private void inheritFromJson(String prefix, Map<String, RunConfig> configs, String name) {
        ArrayList<String> args;
        RunConfig config = configs.get(name);
        if (config == null) {
            return;
        }
        if (config.parents != null) {
            for (String string : config.parents) {
                LOGGER.log(level, "{}Inheriting Json Parent {}", new Object[]{prefix, name});
                this.inheritFromJson(prefix + "  ", configs, string);
            }
        }
        if (config.main != null) {
            LOGGER.log(level, "{}Main-Class: {}", new Object[]{prefix, config.main});
            this.getMainClass().set((Object)config.main);
        }
        if (config.args != null && !config.args.isEmpty()) {
            LOGGER.log(level, "{}Args: {}", new Object[]{prefix, config.args});
            args = new ArrayList<String>(config.args);
            args.addAll((Collection)this.getArgs().getOrElse(List.of()));
            this.getArgs().set(args);
        }
        if (config.jvmArgs != null && !config.jvmArgs.isEmpty()) {
            LOGGER.log(level, "{}JVM Args: {}", new Object[]{prefix, config.jvmArgs});
            args = new ArrayList<String>(config.jvmArgs);
            args.addAll((Collection)this.getJvmArgs().getOrElse(List.of()));
            this.getJvmArgs().set(args);
        }
        LOGGER.log(level, "{}Client: {}", new Object[]{prefix, config.client});
        this.getClient().convention((Object)config.client);
        if (config.buildAllProjects) {
            LOGGER.warn("WARNING: ForgeGradle 7 does not support the buildAllProjects feature.");
        }
        if (config.env != null && !config.env.isEmpty()) {
            for (Map.Entry entry : config.env.entrySet()) {
                LOGGER.log(level, "{}Env: {} = {}", new Object[]{prefix, entry.getKey(), entry.getValue()});
                this.environment((String)entry.getKey(), entry.getValue());
            }
        }
        if (config.props != null && !config.props.isEmpty()) {
            for (Map.Entry entry : config.props.entrySet()) {
                LOGGER.log(level, "{}System: {} = {}", new Object[]{prefix, entry.getKey(), entry.getValue()});
                this.systemProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void inherit(SlimeLauncherOptionsNested target) {
        ArrayList args;
        if (target.getMainClass().isPresent()) {
            LOGGER.log(level, "  MainClass: {}", new Object[]{target.getMainClass().get()});
            this.getMainClass().set(target.getMainClass());
        }
        if (target.getArgs().isPresent() && !((List)target.getArgs().get()).isEmpty()) {
            args = new ArrayList((Collection)this.getArgs().getOrElse(List.of()));
            if (!((Boolean)target.getInheritArgs().getOrElse((Object)Boolean.TRUE)).booleanValue()) {
                args.clear();
            }
            args.addAll((Collection)target.getArgs().get());
            this.getArgs().set(args);
            LOGGER.log(level, "  Args: {}", new Object[]{args});
        }
        if (target.getJvmArgs().isPresent() && !((List)target.getJvmArgs().get()).isEmpty()) {
            args = new ArrayList((Collection)this.getJvmArgs().getOrElse(List.of()));
            if (!((Boolean)target.getInheritJvmArgs().getOrElse((Object)Boolean.TRUE)).booleanValue()) {
                args.clear();
            }
            args.addAll((Collection)target.getJvmArgs().get());
            this.getJvmArgs().set(args);
            LOGGER.log(level, "  JVM Args: {}", new Object[]{args});
        }
        if (target.getMinHeapSize().isPresent()) {
            LOGGER.log(level, "  Min Heap Space: {}", new Object[]{target.getMinHeapSize().get()});
            this.getMinHeapSize().set(target.getMinHeapSize());
        }
        if (target.getMaxHeapSize().isPresent()) {
            LOGGER.log(level, "  Max Heap Space: {}", new Object[]{target.getMaxHeapSize().get()});
            this.getMaxHeapSize().set(target.getMaxHeapSize());
        }
        if (target.getEnvironment().isPresent()) {
            for (Map.Entry entry : ((Map)target.getEnvironment().get()).entrySet()) {
                LOGGER.log(level, "  Env: {} = {}", new Object[]{entry.getKey(), entry.getValue()});
                this.environment((String)entry.getKey(), entry.getValue());
            }
        }
        if (target.getSystemProperties().isPresent()) {
            for (Map.Entry entry : ((Map)target.getSystemProperties().get()).entrySet()) {
                LOGGER.log(level, "  System: {} = {}", new Object[]{entry.getKey(), entry.getValue()});
                this.systemProperty((String)entry.getKey(), entry.getValue());
            }
        }
        if (target.getWorkingDir().isPresent()) {
            LOGGER.log(level, "  WorkingDir: {}", new Object[]{target.getWorkingDir().get()});
            this.getWorkingDir().set((Provider)target.getWorkingDir());
        }
    }

    public String toString() {
        return "SlimeLauncherOptionsImpl{name=" + this.name + ", mainClass=" + (String)this.mainClass.getOrNull() + ", args=[" + String.join((CharSequence)", ", (Iterable)this.args.getOrElse(List.of())) + "], jvmArgs=[" + String.join((CharSequence)", ", (Iterable)this.jvmArgs.getOrElse(List.of())) + "], classpath=[" + this.classpath.getAsPath() + "], minHeapSize=" + (String)this.minHeapSize.getOrNull() + ", maxHeapSize=" + (String)this.maxHeapSize.getOrNull() + ", systemProperties=" + String.valueOf(this.systemProperties.getOrNull()) + ", environment=" + String.valueOf(this.environment.getOrNull()) + ", workingDir=" + String.valueOf(this.workingDir.getOrNull()) + ", client=" + String.valueOf(this.client.getOrNull()) + "}";
    }
}

