/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import net.minecraftforge.gradle.internal.ForgeGradleTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class SlimeLauncherMetadata
extends DefaultTask
implements ForgeGradleTask {
    @InputFiles
    protected abstract ConfigurableFileCollection getMetadata();

    @OutputFile
    protected abstract RegularFileProperty getRunsJson();

    @Inject
    public SlimeLauncherMetadata() {
        this.getRunsJson().convention(this.getDefaultOutputDirectory().map(d -> d.file("runs.json")));
    }

    @TaskAction
    protected void exec() throws IOException {
        File archive = this.getMetadata().getSingleFile();
        Path json = ((File)this.getRunsJson().getAsFile().get()).toPath();
        boolean foundRuns = false;
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(archive));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().startsWith("launcher/") || !entry.getName().equals("launcher/runs.json")) continue;
                Files.copy(zin, json, StandardCopyOption.REPLACE_EXISTING);
                foundRuns = true;
            }
        }
        if (!foundRuns) {
            Files.writeString(json, (CharSequence)"{}", StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }
}

