/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.ForgeGradleTask;
import net.minecraftforge.gradle.internal.SlimeLauncherEclipseConfiguration;
import net.minecraftforge.gradle.internal.SlimeLauncherMetadata;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsInternal;
import net.minecraftforge.gradle.internal.Tools;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.com.google.gson.JsonIOException;
import net.minecraftforge.gradle.shadow.com.google.gson.reflect.TypeToken;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Running the game cannot be cached")
abstract class SlimeLauncherExec
extends JavaExec
implements ForgeGradleTask,
HasPublicType {
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjectFactory().newInstance(ForgeGradleProblems.class, new Object[0]);

    static TaskProvider<SlimeLauncherExec> register(Project project, SourceSet sourceSet, SlimeLauncherOptionsImpl options, ModuleIdentifier module, String version, String asPath, String asString, boolean single) {
        TaskProvider t;
        String taskName = "slimeLauncherMetadata" + (String)(single ? "" : "for" + Util.dependencyToCamelCase(module));
        try {
            t = project.getTasks().named(taskName, SlimeLauncherMetadata.class);
        }
        catch (UnknownDomainObjectException e) {
            Configuration metadataConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencyFactory().create(module.getGroup(), module.getName(), version, "metadata", "zip")});
            metadataConfiguration.setTransitive(false);
            metadataConfiguration.attributes(a -> a.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)a.named(Usage.class, "metadata"))));
            t = project.getTasks().register(taskName, SlimeLauncherMetadata.class, task -> {
                task.setDescription("Extracts the Slime Launcher metadata%s.".formatted(single ? "" : " for '%s'".formatted(asString)));
                task.getMetadata().setFrom((Iterable)metadataConfiguration);
            });
        }
        TaskProvider metadata = t;
        String taskNameSuffix = single ? "" : "for" + Util.dependencyToCamelCase(module);
        String runTaskName = sourceSet.getTaskName("run", options.getName()) + taskNameSuffix;
        String generateEclipseRunTaskName = sourceSet.getTaskName("genEclipseRun", options.getName()) + taskNameSuffix;
        TaskProvider genEclipseRun = project.getTasks().register(generateEclipseRunTaskName, SlimeLauncherEclipseConfiguration.class, task -> {
            task.getRunName().set((Object)options.getName());
            task.setDescription("Generates the '%s' Slime Launcher run configuration for Eclipse.".formatted(options.getName()));
            task.getOutputFile().set((Object)task.getProjectLayout().getProjectDirectory().file(runTaskName + ".launch"));
            ConfigurableFileCollection runtimeClasspath = task.getObjects().fileCollection().from(new Object[]{task.getProviders().provider(() -> {
                FileCollection runtime = sourceSet.getRuntimeClasspath();
                EclipseModel eclipseModel = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
                if (eclipseModel == null) {
                    return runtime.getFiles();
                }
                EclipseClasspath classpath = eclipseModel.getClasspath();
                List<SourceSet> sortedSourceSets = SlimeLauncherExec.sortSourceSets(classpath.getSourceSets());
                HashMap<File, File> replacements = new HashMap<File, File>();
                File base = (File)classpath.getBaseSourceOutputDir().getAsFile().get();
                HashSet<File> claimed = new HashSet<File>();
                claimed.add(classpath.getDefaultOutputDir());
                for (SourceSet sources : sortedSourceSets) {
                    Object name = sources.getName();
                    File path = new File(base, (String)name);
                    while (claimed.contains(path)) {
                        name = (String)name + "_";
                        path = new File(base, (String)name);
                    }
                    claimed.add(path);
                    if (sources.getOutput().getResourcesDir() != null) {
                        replacements.put(sources.getOutput().getResourcesDir(), path);
                    }
                    for (File dir : sources.getOutput().getClassesDirs().getFiles()) {
                        replacements.put(dir, path);
                    }
                }
                LinkedHashSet<File> ret = new LinkedHashSet<File>(runtime.getFiles().size());
                for (File file : runtime.getFiles()) {
                    ret.add(replacements.getOrDefault(file, file));
                }
                return ret;
            })});
            task.getClasspath().from(new Object[]{runtimeClasspath});
            task.getSourceSetName().set((Object)sourceSet.getName());
            task.getCacheDir().set((Provider)task.getObjects().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s".formatted(asPath)).map(task.problems.ensureFileLocation())));
            task.getMetadata().setFrom(new Object[]{metadata.map(SlimeLauncherMetadata::getMetadata)});
            task.getRunsJson().set(metadata.flatMap(SlimeLauncherMetadata::getRunsJson));
            task.getOptions().set((Object)options);
        });
        project.getTasks().named("genEclipseRuns", task -> task.dependsOn(new Object[]{genEclipseRun}));
        return project.getTasks().register(runTaskName, SlimeLauncherExec.class, task -> {
            task.getRunName().set((Object)options.getName());
            task.getSourceSetName().set((Object)sourceSet.getName());
            task.setDescription("Runs the '%s' Slime Launcher run configuration.".formatted(options.getName()));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = task.getProviderFactory().provider(() -> ((SourceSet)sourceSet).getRuntimeClasspath());
            objectArray[0] = task.getObjectFactory().fileCollection().from(objectArray2);
            task.classpath(objectArray);
            DirectoryProperty caches = task.getObjectFactory().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s".formatted(asPath)));
            task.getCacheDir().set(caches.map(task.problems.ensureFileLocation()));
            task.getMetadata().setFrom(new Object[]{metadata.map(SlimeLauncherMetadata::getMetadata)});
            task.getRunsJson().set(metadata.flatMap(SlimeLauncherMetadata::getRunsJson));
            task.getOptions().set((Object)options);
        });
    }

    @Input
    protected abstract Property<String> getRunName();

    @Input
    protected abstract Property<String> getSourceSetName();

    @Nested
    protected abstract Property<SlimeLauncherOptions> getOptions();

    @Internal
    protected abstract DirectoryProperty getCacheDir();

    @InputFiles
    protected abstract ConfigurableFileCollection getMetadata();

    @InputFile
    @Optional
    protected abstract RegularFileProperty getRunsJson();

    @Input
    @Optional
    protected abstract Property<Boolean> getClient();

    @Internal
    protected abstract MapProperty<String, String> getForkProperties();

    @Inject
    public SlimeLauncherExec() {
        this.setGroup("Slime Launcher");
        Tool.Resolved tool = this.getTool(Tools.SLIMELAUNCHER);
        this.setClasspath(tool.getClasspath());
        if (tool.hasMainClass()) {
            this.getMainClass().set((Object)tool.getMainClass());
        }
        this.getJavaLauncher().set(Util.launcherFor(this.getProject(), tool.getJavaVersion()));
        this.getModularity().getInferModulePath().set((Object)false);
        this.getForkProperties().set(Util.getForkProperties(this.getProviderFactory()));
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaExec.class);
    }

    public void exec() {
        Map<String, RunConfig> configs = Map.of();
        File jsons = (File)this.getRunsJson().getAsFile().getOrNull();
        if (jsons != null && jsons.exists()) {
            try {
                configs = JsonData.fromJson((File)this.getRunsJson().getAsFile().get(), new TypeToken<Map<String, RunConfig>>(){});
            }
            catch (JsonIOException jsonIOException) {
                // empty catch block
            }
        }
        SlimeLauncherOptionsInternal options = ((SlimeLauncherOptionsInternal)this.getOptions().get()).inherit(configs, (String)this.getSourceSetName().get());
        Provider mainClass = options.getMainClass().filter(Util::isPresent);
        ArrayList args = new ArrayList((Collection)options.getArgs().getOrElse(List.of()));
        this.jvmArgs((Iterable)options.getJvmArgs().get());
        if (!options.getClasspath().isEmpty()) {
            this.setClasspath((FileCollection)options.getClasspath());
        }
        if (options.getMinHeapSize().filter(Util::isPresent).isPresent()) {
            this.setMinHeapSize((String)options.getMinHeapSize().get());
        }
        if (options.getMaxHeapSize().filter(Util::isPresent).isPresent()) {
            this.setMinHeapSize((String)options.getMaxHeapSize().get());
        }
        this.systemProperties((Map)options.getSystemProperties().get());
        this.environment((Map)options.getEnvironment().get());
        this.workingDir(options.getWorkingDir().get());
        if (!((String)this.getMainClass().get()).startsWith("net.minecraftforge.launcher")) {
            this.getLogger().warn("WARNING: Main class is not Slime Launcher! Skipping additional configuration.");
        } else {
            this.args(new Object[]{"--main", mainClass.get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", this.getMetadata().getSingleFile().getAbsolutePath(), "--"});
        }
        this.args(args);
        if (!((Boolean)this.getClient().getOrElse((Object)false)).booleanValue()) {
            this.setStandardInput(System.in);
        }
        try {
            Files.createDirectories(this.getWorkingDir().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            super.exec();
        }
        catch (Exception e) {
            this.getLogger().error("Something went wrong! Here is some debug info.");
            this.getLogger().error("Args: {}", (Object)this.getArgs());
            this.getLogger().error("Options: {}", (Object)options);
            throw e;
        }
    }

    private static List<SourceSet> sortSourceSets(@Nullable Iterable<SourceSet> sourceSets) {
        if (sourceSets == null) {
            return new ArrayList<SourceSet>(0);
        }
        ArrayList<SourceSet> ret = new ArrayList<SourceSet>();
        for (SourceSet item : sourceSets) {
            ret.add(item);
        }
        ret.sort(Comparator.comparing(SlimeLauncherExec::toComparable));
        return ret;
    }

    private static Integer toComparable(SourceSet sourceSet) {
        String name = sourceSet.getName();
        if ("main".equals(name)) {
            return 0;
        }
        if ("test".equals(name)) {
            return 1;
        }
        return 2;
    }
}

