/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.ForgeGradleTask;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsInternal;
import net.minecraftforge.gradle.internal.Tools;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.com.google.gson.JsonIOException;
import net.minecraftforge.gradle.shadow.com.google.gson.reflect.TypeToken;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@DisableCachingByDefault(because="ForgeGradle would require more information to cache this task")
abstract class SlimeLauncherEclipseConfiguration
extends DefaultTask
implements ForgeGradleTask {
    final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

    @OutputFile
    protected abstract RegularFileProperty getOutputFile();

    @Input
    protected abstract Property<String> getProjectName();

    @Input
    protected abstract Property<String> getSourceSetName();

    @Input
    @Optional
    protected abstract Property<String> getEclipseProjectName();

    @Input
    protected abstract Property<String> getRunName();

    @Nested
    protected abstract Property<JavaLauncher> getJavaLauncher();

    @InputFiles
    @Classpath
    protected abstract ConfigurableFileCollection getClasspath();

    @Input
    protected abstract Property<String> getMainClass();

    @Nested
    protected abstract Property<SlimeLauncherOptions> getOptions();

    @Internal
    protected abstract DirectoryProperty getCacheDir();

    @InputFiles
    protected abstract ConfigurableFileCollection getMetadata();

    @InputFile
    @Optional
    protected abstract RegularFileProperty getRunsJson();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public SlimeLauncherEclipseConfiguration() {
        this.getProjectName().convention((Object)this.getProject().getName());
        this.getEclipseProjectName().convention(this.getProviders().provider(() -> {
            EclipseModel eclipse = (EclipseModel)this.getProject().getExtensions().findByType(EclipseModel.class);
            return eclipse == null ? null : eclipse.getProject().getName();
        }));
        Tool.Resolved tool = this.getTool(Tools.SLIMELAUNCHER);
        this.getClasspath().from(new Object[]{tool.getClasspath()});
        this.getMainClass().set((Object)tool.getMainClass());
        this.getJavaLauncher().set(Util.launcherFor(this.getProject(), tool.getJavaVersion()));
    }

    @TaskAction
    protected void exec() {
        if (!this.getEclipseProjectName().isPresent()) {
            this.problems.reportMissingEclipsePlugin(this.getName());
        }
        Map<String, RunConfig> configs = Map.of();
        File jsons = (File)this.getRunsJson().getAsFile().getOrNull();
        if (jsons != null && jsons.exists()) {
            try {
                configs = JsonData.fromJson((File)this.getRunsJson().getAsFile().get(), new TypeToken<Map<String, RunConfig>>(){});
            }
            catch (JsonIOException jsonIOException) {
                // empty catch block
            }
        }
        SlimeLauncherOptionsInternal options = ((SlimeLauncherOptionsInternal)this.getOptions().get()).inherit(configs, (String)this.getSourceSetName().get());
        ArrayList<String> args = new ArrayList<String>((Collection)options.getArgs().getOrElse(List.of()));
        ArrayList<CallSite> jvmArgs = new ArrayList<CallSite>((Collection)options.getJvmArgs().getOrElse(List.of()));
        if (!options.getClasspath().isEmpty()) {
            this.getClasspath().setFrom((Iterable)options.getClasspath());
        }
        if (options.getMinHeapSize().filter(Util::isPresent).isPresent()) {
            jvmArgs.add((CallSite)((Object)("-Xms" + (String)options.getMinHeapSize().get())));
        }
        if (options.getMaxHeapSize().filter(Util::isPresent).isPresent()) {
            jvmArgs.add((CallSite)((Object)("-Xmx" + (String)options.getMaxHeapSize().get())));
        }
        for (Map.Entry property : ((Map)options.getSystemProperties().getOrElse(Map.of())).entrySet()) {
            jvmArgs.add((CallSite)((Object)("-D" + (String)property.getKey() + "=" + (String)property.getValue())));
        }
        MapProperty<String, String> environment = options.getEnvironment();
        DirectoryProperty workingDir = options.getWorkingDir();
        args.addAll(0, List.of("--main", (String)options.getMainClass().get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", this.getMetadata().getSingleFile().getAbsolutePath(), "--"));
        try {
            Files.createDirectories(((Directory)workingDir.get()).getAsFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        WorkQueue queue = this.getWorkerExecutor().classLoaderIsolation();
        queue.submit(Action.class, parameters -> {
            parameters.getOutputFile().set((Provider)this.getOutputFile());
            parameters.getEclipseProjectName().set(this.getEclipseProjectName().orElse(this.getProjectName()));
            parameters.getClasspath().setFrom((Iterable)this.getClasspath());
            parameters.getMainClass().set((Object)((String)this.getMainClass().get()));
            parameters.getArgs().set((Iterable)args);
            parameters.getJvmArgs().set((Iterable)jvmArgs);
            parameters.getWorkingDir().set((Provider)workingDir);
            parameters.getEnvironment().set((Provider)environment);
            parameters.getJavaHome().set(this.getJavaLauncher().map(j -> j.getMetadata().getInstallationPath()));
        });
    }

    static abstract class Action
    implements WorkAction<Parameters> {
        private static final String CLASSPATH_ENTRY_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> <runtimeClasspathEntry externalArchive=\"";
        private static final String CLASSPATH_ENTRY_SUFFIX = "\" path=\"5\" type=\"2\"/>";

        @Inject
        public Action() {
        }

        public void execute() {
            Transformer transformer;
            DocumentBuilder documentBuilder;
            Parameters parameters = (Parameters)this.getParameters();
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (ParserConfigurationException | TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            Document launch = documentBuilder.newDocument();
            Element rootElement = launch.createElement("launchConfiguration");
            rootElement.setAttribute("type", "org.eclipse.jdt.launching.localJavaApplication");
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.PROJECT_ATTR", parameters.getEclipseProjectName().get());
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.MAIN_TYPE", parameters.getMainClass().get());
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.VM_ARGUMENTS", String.join((CharSequence)" ", (Iterable)parameters.getJvmArgs().get()));
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", String.join((CharSequence)" ", (Iterable)parameters.getArgs().get()));
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.WORKING_DIRECTORY", ((File)parameters.getWorkingDir().getAsFile().get()).getAbsolutePath());
            Action.mapAttribute(launch, rootElement, "org.eclipse.debug.core.environmentVariables", (Map)parameters.getEnvironment().get());
            Action.classpathAttribute(launch, rootElement, (FileCollection)parameters.getClasspath());
            Action.booleanAttribute(launch, rootElement, "org.eclipse.jdt.launching.DEFAULT_CLASSPATH", false);
            launch.appendChild(rootElement);
            DOMSource source = new DOMSource(launch);
            StreamResult result = new StreamResult((File)parameters.getOutputFile().getAsFile().get());
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }

        private static void stringAttribute(Document document, Element parent, String key, Object value) {
            Element attribute = document.createElement("stringAttribute");
            attribute.setAttribute("key", key);
            attribute.setAttribute("value", value.toString());
            parent.appendChild(attribute);
        }

        private static void booleanAttribute(Document document, Element parent, String key, boolean value) {
            Element attribute = document.createElement("booleanAttribute");
            attribute.setAttribute("key", key);
            attribute.setAttribute("value", Boolean.toString(value));
            parent.appendChild(attribute);
        }

        private static void listAttribute(Document document, Element parent, String key, Iterable<?> list) {
            Element attribute = document.createElement("listAttribute");
            attribute.setAttribute("key", key);
            for (Object v : list) {
                Element listEntry = document.createElement("listEntry");
                listEntry.setAttribute("value", v.toString());
                attribute.appendChild(listEntry);
            }
            parent.appendChild(attribute);
        }

        private static void classpathAttribute(Document document, Element parent, FileCollection files) {
            Element attribute = document.createElement("listAttribute");
            attribute.setAttribute("key", "org.eclipse.jdt.launching.CLASSPATH");
            for (File v : files.getFiles()) {
                Element listEntry = document.createElement("listEntry");
                listEntry.setAttribute("value", CLASSPATH_ENTRY_PREFIX + String.valueOf(v) + CLASSPATH_ENTRY_SUFFIX);
                attribute.appendChild(listEntry);
            }
            parent.appendChild(attribute);
        }

        private static void mapAttribute(Document document, Element parent, String key, Map<String, ?> map) {
            Element attribute = document.createElement("mapAttribute");
            attribute.setAttribute("key", key);
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                Element mapEntry = document.createElement("mapEntry");
                mapEntry.setAttribute("key", k);
                mapEntry.setAttribute("value", v.toString());
                attribute.appendChild(mapEntry);
            }
            parent.appendChild(attribute);
        }

        static interface Parameters
        extends WorkParameters {
            public RegularFileProperty getOutputFile();

            public Property<String> getEclipseProjectName();

            public ConfigurableFileCollection getClasspath();

            public Property<String> getMainClass();

            public ListProperty<String> getArgs();

            public ListProperty<String> getJvmArgs();

            public DirectoryProperty getWorkingDir();

            public DirectoryProperty getJavaHome();

            public MapProperty<String, String> getEnvironment();
        }
    }
}

