/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */
package net.minecraftforge.gradle;

import org.gradle.api.artifacts.ExternalModuleDependency;

/// A closure owner is used to replace a closure's owner to allow for multiple delegates.
///
/// This is done to allow for buildscript authors to work with an abstraction that implements multiple interfaces
/// without needing to create an object that does so. For example, the [net.minecraftforge.gradle.MinecraftDependency]
/// implementation is not itself an [ExternalModuleDependency], but the [MinecraftDependency] closure owner provides an
/// abstraction that delegates to both of those interfaces simultaneously.
public interface ClosureOwner {
    /// A closure owner that delegates to [net.minecraftforge.gradle.MinecraftDependency] and
    /// [ExternalModuleDependency].
    ///
    /// @see ClosureOwner
    interface MinecraftDependency extends ClosureOwner, net.minecraftforge.gradle.MinecraftDependency, ExternalModuleDependency { }
}
