/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Map;
import net.minecraftforge.gradle.MavenizerInstance;
import net.minecraftforge.gradle.internal.MinecraftExtensionImpl;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;

class MavenizerInstanceImpl
implements MavenizerInstance {
    private final MinecraftExtensionImpl.ForProjectImpl extension;
    private final Provider<Boolean> valueSource;
    private final ExternalModuleDependency dependency;
    private final File jsonFile;
    private final MapProperty<String, String> invoke;
    private @Nullable Map<String, String> map;

    MavenizerInstanceImpl(MinecraftExtensionImpl.ForProjectImpl extension, Provider<Boolean> valueSource, ExternalModuleDependency dependency, File jsonFile) {
        this.extension = extension;
        this.dependency = dependency;
        this.valueSource = valueSource;
        this.jsonFile = jsonFile;
        this.invoke = this.extension.getObjects().mapProperty(String.class, String.class).convention(this.extension.getProviders().provider(this::invoke));
    }

    private Map<String, String> invoke() {
        if (this.map == null) {
            this.valueSource.get();
            this.map = (Map)new JsonSlurper().parse(this.jsonFile, "UTF-8");
        }
        return this.map;
    }

    private Provider<String> get(String key) {
        return this.invoke.getting((Object)key).orElse(this.extension.getProviders().provider(() -> {
            throw new IllegalStateException("Mavenizer did not output expected json data " + key);
        }));
    }

    @Override
    public Provider<ExternalModuleDependency> asProvider() {
        return this.invoke.map(m -> this.dependency);
    }

    @Override
    public Provider<String> getMappingVersion() {
        return this.get("mappings.version");
    }

    @Override
    public Provider<String> getToSrg() {
        return this.get("mappings.srg.artifact");
    }

    @Override
    public Provider<File> getToSrgFile() {
        return this.get("mappings.srg.file").map(arg_0 -> ((Project)this.extension.getProject()).file(arg_0));
    }

    @Override
    public Provider<String> getToObf() {
        return this.get("mappings.obf.artifact");
    }

    @Override
    public Provider<File> getToObfFile() {
        return this.get("mappings.obf.file").map(arg_0 -> ((Project)this.extension.getProject()).file(arg_0));
    }
}

