/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import groovy.lang.Closure;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.internal.ForgeAttributes;
import net.minecraftforge.gradle.internal.ForgeGradleFlowAction;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.MinecraftDependencyInternal;
import net.minecraftforge.gradle.internal.MinecraftExtensionInternal;
import net.minecraftforge.gradle.internal.MinecraftMappingsImpl;
import net.minecraftforge.gradle.internal.MinecraftMappingsInternal;
import net.minecraftforge.gradle.internal.SlimeLauncherExec;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.flow.FlowProviders;
import org.gradle.api.flow.FlowScope;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jspecify.annotations.Nullable;

abstract class MinecraftDependencyImpl
implements MinecraftDependencyInternal {
    private transient @Nullable ExternalModuleDependency delegate;
    private transient @Nullable NamedDomainObjectContainer<SlimeLauncherOptionsImpl> runs;
    private final MinecraftExtensionInternal.ForProject minecraft = (MinecraftExtensionInternal.ForProject)this.getProject().getExtensions().getByType(MinecraftExtensionForProject.class);
    private final ConfigurableFileCollection accessTransformer = this.getObjects().fileCollection();
    private final Property<String> accessTransformerPath = this.getObjects().property(String.class);
    private final Property<String> asString = this.getObjects().property(String.class);
    private final Property<String> asPath = this.getObjects().property(String.class);
    private final Property<ModuleIdentifier> module = this.getObjects().property(ModuleIdentifier.class);
    private final Property<String> version = this.getObjects().property(String.class);
    private final DirectoryProperty mavenizerOutput = this.getObjects().directoryProperty();
    private final Property<MinecraftMappingsInternal> mappings = this.getObjects().property(MinecraftMappingsInternal.class);
    private @Nullable String sourceSetName;
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract FlowScope getFlowScope();

    @Inject
    protected abstract FlowProviders getFlowProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    public MinecraftDependencyImpl(Provider<? extends Directory> mavenizerOutput) {
        this.mavenizerOutput.set(mavenizerOutput);
        this.mappings.convention(this.minecraft.getMappingsProperty());
    }

    @Override
    public @Nullable NamedDomainObjectContainer<? extends SlimeLauncherOptions> getRuns() {
        return this.runs;
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        this.mappings.set((Object)((MinecraftMappingsInternal)this.getObjects().newInstance(MinecraftMappingsImpl.class, new Object[]{channel, version})));
    }

    @Override
    public boolean hasAccessTransformersPlugin() {
        return this.minecraft.hasAccessTransformersPlugin();
    }

    @Override
    public ConfigurableFileCollection getAccessTransformer() {
        return this.accessTransformer;
    }

    @Override
    public Property<String> getAccessTransformerPath() {
        return this.accessTransformerPath;
    }

    private boolean hasAccessTransformers() {
        return !this.accessTransformer.isEmpty() || this.accessTransformerPath.isPresent();
    }

    @Override
    public @Nullable ExternalModuleDependency asDependency() {
        return this.delegate;
    }

    @Override
    public ExternalModuleDependency init(Object dependencyNotation, Closure<?> closure) {
        this.runs = this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class);
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getProject().getDependencies().create(dependencyNotation, Closures.function(d -> {
            if (!(d instanceof ExternalModuleDependency)) {
                throw this.problems.invalidMinecraftDependencyType((Dependency)d);
            }
            ExternalModuleDependency module = (ExternalModuleDependency)d;
            if (module.isChanging()) {
                throw this.problems.changingMinecraftDependency((Dependency)module);
            }
            Closures.invoke(this.closure(closure), module);
            ((ExtensionAware)module).getExtensions().getExtraProperties().set("__fg_minecraft_dependency", (Object)this);
            return module;
        }));
        this.asString.set((Object)dependency.toString());
        this.asPath.set((Object)Util.pathify((Dependency)dependency));
        this.module.set((Object)dependency.getModule());
        this.version.set((Object)dependency.getVersion());
        this.delegate = dependency;
        return this.delegate;
    }

    @Override
    public void handle(Configuration configuration) {
        if (configuration.isCanBeResolved()) {
            String moduleSelector = "%s:%s".formatted(this.module.get(), this.version.get());
            ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
            DependencySubstitutions dependencySubstitution = resolutionStrategy.getDependencySubstitution();
            if (this.mappings.isPresent()) {
                ComponentSelector module = dependencySubstitution.module(moduleSelector);
                try {
                    dependencySubstitution.substitute(module).using(dependencySubstitution.variant(module, variant -> variant.attributes(attributes -> {
                        attributes.attributeProvider(ForgeAttributes.MappingsChannel.ATTRIBUTE, this.mappings.map(MinecraftMappings::getChannel));
                        attributes.attributeProvider(ForgeAttributes.MappingsVersion.ATTRIBUTE, this.mappings.map(MinecraftMappings::getVersion));
                    }))).because("Accounts for declared mappings.");
                }
                catch (InvalidUserCodeException e) {
                    throw new IllegalStateException("Resolvable configuration '%s' was resolved too early!".formatted(configuration.getName()), e);
                }
            }
        }
    }

    @Override
    public void handle(NamedDomainObjectSet<SourceSet> sourceSets, NamedDomainObjectSet<SourceSet> allSourceSets) {
        String asString = (String)this.asString.get();
        Provider dependencyOutput = this.mavenizerOutput.dir(this.asPath);
        this.getFlowScope().always(ForgeGradleFlowAction.MavenizerSyncCheck.class, spec -> spec.parameters(parameters -> {
            parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(r -> r.getFailure().orElse(null)));
            parameters.dependencyOutput.set(dependencyOutput);
            parameters.dependency.set((Object)asString);
        }));
        if (!sourceSets.isEmpty() && this.sourceSetName == null) {
            this.sourceSetName = ((SourceSet)sourceSets.iterator().next()).getName();
        }
        NamedDomainObjectContainer runs = Objects.requireNonNullElseGet(this.getRuns(), () -> this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class));
        runs.addAll(this.minecraft.getRuns());
        allSourceSets.configureEach(sourceSet -> {
            boolean single = this.getProject().getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()).getAllDependencies().matching(MinecraftDependencyInternal::is).size() == 1;
            runs.forEach(options -> {
                TaskProvider<SlimeLauncherExec> task = SlimeLauncherExec.register(this.getProject(), sourceSet, (SlimeLauncherOptionsImpl)options, (ModuleIdentifier)this.module.get(), (String)this.version.get(), (String)this.asPath.get(), asString, single);
            });
        });
        this.finalizeAccessTransformers(sourceSets);
    }

    void finalizeAccessTransformers(NamedDomainObjectSet<SourceSet> sourceSets) {
        if (this.accessTransformer.isEmpty() && !this.accessTransformerPath.isPresent()) {
            this.accessTransformer.convention((Iterable)this.minecraft.getAccessTransformer());
            this.accessTransformerPath.convention((Provider)this.minecraft.getAccessTransformerPath());
        }
        if (this.accessTransformer.isEmpty() && this.accessTransformerPath.isPresent() && !sourceSets.isEmpty()) {
            SourceSet sourceSet = (SourceSet)sourceSets.iterator().next();
            Iterator itor = sourceSet.getResources().getSrcDirs().iterator();
            if (itor.hasNext()) {
                File file = (File)itor.next();
                this.accessTransformer.setFrom(new Object[]{this.getProjectLayout().file(this.accessTransformerPath.map(atPath -> new File(file, (String)atPath)))});
            } else {
                String sourceSetName = sourceSet.getName();
                this.accessTransformer.setFrom(new Object[]{this.getProjectLayout().getProjectDirectory().file(this.accessTransformerPath.map(atPath -> "src/" + sourceSetName + "/resources/" + atPath))});
            }
        }
    }
}

