/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedProblems
implements Serializable,
Predicate<String> {
    private static final long serialVersionUID = 2037193772993696096L;
    protected static final String HELP_MESSAGE = "Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.";
    private final String displayName;
    private final ProblemGroup problemGroup;

    @Deprecated
    @Inject
    protected abstract Problems getProblems();

    @Inject
    protected abstract ProviderFactory getProviders();

    public final Problems getDelegate() {
        try {
            return this.getProblems();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get Problems instance! This is an unrecoverable error, likely due to the removal of (the service injection of) the incubating Problems API in a Gradle update. Please report this to MinecraftForge.", e);
        }
    }

    @Deprecated(forRemoval=true, since="3.2.26")
    protected final ProblemReporter getReporter() {
        return this.getDelegate().getReporter();
    }

    public final ProblemGroup getProblemGroup() {
        return this.problemGroup;
    }

    protected EnhancedProblems(String name, String displayName) {
        this.displayName = displayName;
        this.problemGroup = ProblemGroup.create((String)name, (String)this.displayName);
    }

    protected final Logger getLogger() {
        return Logging.getLogger(this.getClass());
    }

    protected final void report(String name, String displayName, Action<? super ProblemSpec> spec) {
        this.getDelegate().getReporter().report(ProblemId.create((String)name, (String)displayName, (ProblemGroup)this.getProblemGroup()), spec);
    }

    protected final RuntimeException throwing(Throwable exception, String name, String displayName, Action<? super ProblemSpec> spec) {
        return this.getDelegate().getReporter().throwing(exception instanceof RuntimeException ? exception : new RuntimeException(exception), ProblemId.create((String)name, (String)displayName, (ProblemGroup)this.getProblemGroup()), spec);
    }

    @Deprecated(forRemoval=true, since="3.2.26")
    protected final ProblemId id(String name, String displayName) {
        return ProblemId.create((String)name, (String)displayName, (ProblemGroup)this.getProblemGroup());
    }

    @Override
    public final boolean test(String property) {
        try {
            return EnhancedProblems.isTrue(this.getProviders(), property);
        }
        catch (Exception e) {
            return Boolean.getBoolean(property);
        }
    }

    public final boolean testFalse(String property) {
        try {
            return EnhancedProblems.isFalse(this.getProviders(), property);
        }
        catch (Exception e) {
            return Boolean.getBoolean(property);
        }
    }

    final RuntimeException illegalPluginTarget(Exception e, Class<?> firstAllowedTarget, Class<?> ... allowedTargets) {
        return this.throwing(e, "invalid-plugin-target", "Invalid plugin target", (Action<? super ProblemSpec>)((Action)spec -> spec.details("Attempted to apply the %s plugin to an invalid target.\nThis plugin can only be applied on the following types:\n%s".formatted(this.displayName, Stream.concat(Stream.of(firstAllowedTarget), Stream.of(allowedTargets)).map(Class::getName).collect(Collectors.joining(", ", "[", "]")))).severity(Severity.ERROR).stackLocation().solution("Use a valid plugin target.").solution(HELP_MESSAGE)));
    }

    final RuntimeException illegalPluginTarget(Exception e, String allowedTargets) {
        return this.throwing(e, "invalid-plugin-target", "Invalid plugin target", (Action<? super ProblemSpec>)((Action)spec -> spec.details("Attempted to apply the %s plugin to an invalid target.\nThis plugin can only be applied on %s.".formatted(this.displayName, allowedTargets)).severity(Severity.ERROR).stackLocation().solution("Use a valid plugin target.").solution(HELP_MESSAGE)));
    }

    final RuntimeException pluginNotYetApplied(Exception e) {
        return this.throwing(e, "plugin-not-yet-applied", String.format("%s is not applied", this.displayName), (Action<? super ProblemSpec>)((Action)spec -> spec.details("Attempted to get details from the %s plugin, but it has not yet been applied to the target.".formatted(this.displayName)).severity(Severity.ERROR).stackLocation().solution("Apply the plugin before attempting to use it from the target's plugin manager.").solution("Apply the plugin before attempting to register any of its tasks, especially those that require in-house caching or tools.").solution(HELP_MESSAGE)));
    }

    public final <T extends FileSystemLocation> Transformer<T, T> ensureFileLocation() {
        return file -> {
            File dir = file instanceof Directory ? file.getAsFile() : file.getAsFile().getParentFile();
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw this.throwing(e, "cannot-ensure-directory", "Failed to create directory", (Action<? super ProblemSpec>)((Action)spec -> spec.details("Failed to create a directory required for %s to function.\nDirectory: %s".formatted(this.displayName, dir.getAbsolutePath())).severity(Severity.ERROR).stackLocation().solution("Ensure that the you have write access to the directory that needs to be created.").solution(HELP_MESSAGE)));
            }
            return file;
        };
    }

    @Nullable
    private static Boolean getBoolean(Provider<? extends String> provider) {
        if (Boolean.TRUE.equals(provider.map("true"::equalsIgnoreCase).getOrNull())) {
            return true;
        }
        if (Boolean.FALSE.equals(provider.map("false"::equalsIgnoreCase).getOrNull())) {
            return false;
        }
        return null;
    }

    private static boolean isTrue(ProviderFactory providers, String property) {
        return EnhancedProblems.isTrue((Provider<? extends String>)providers.gradleProperty(property)) || EnhancedProblems.isTrue((Provider<? extends String>)providers.systemProperty(property));
    }

    private static boolean isTrue(Provider<? extends String> provider) {
        return Boolean.TRUE.equals(EnhancedProblems.getBoolean(provider));
    }

    private static boolean isFalse(ProviderFactory providers, String property) {
        return EnhancedProblems.isFalse((Provider<? extends String>)providers.gradleProperty(property)) || EnhancedProblems.isFalse((Provider<? extends String>)providers.systemProperty(property));
    }

    private static boolean isFalse(Provider<? extends String> provider) {
        return Boolean.FALSE.equals(EnhancedProblems.getBoolean(provider));
    }

    static abstract class Minimal
    extends EnhancedProblems
    implements HasPublicType {
        private static final long serialVersionUID = -6804792858587052477L;

        @Inject
        public Minimal(String name, String displayName) {
            super(name, displayName);
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(EnhancedProblems.class);
        }
    }

    private static interface EmptyReporter
    extends ProblemReporter,
    HasPublicType {
        public static final EmptyReporter INSTANCE = new EmptyReporter(){};
        public static final Problems AS_PROBLEMS = () -> INSTANCE;

        default public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(ProblemReporter.class);
        }

        default public Problem create(ProblemId problemId, Action<? super ProblemSpec> action) {
            return new Problem(){};
        }

        default public void report(ProblemId problemId, Action<? super ProblemSpec> spec) {
        }

        default public void report(Problem problem) {
        }

        default public void report(Collection<? extends Problem> problems) {
        }

        default public RuntimeException throwing(Throwable exception, ProblemId problemId, Action<? super ProblemSpec> spec) {
            return this.toRTE(exception);
        }

        default public RuntimeException throwing(Throwable exception, Problem problem) {
            return this.toRTE(exception);
        }

        default public RuntimeException throwing(Throwable exception, Collection<? extends Problem> problems) {
            return this.toRTE(exception);
        }

        default public RuntimeException toRTE(Throwable exception) {
            return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
        }
    }
}

