/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.gradle.MinecraftExtension;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.SlimeLauncherOptions;
import net.minecraftforge.gradle.internal.ForgeAttributes;
import net.minecraftforge.gradle.internal.ForgeGradleComponentMetadataRules;
import net.minecraftforge.gradle.internal.ForgeGradleFlowAction;
import net.minecraftforge.gradle.internal.ForgeGradleMessage;
import net.minecraftforge.gradle.internal.ForgeGradlePlugin;
import net.minecraftforge.gradle.internal.ForgeGradleProblems;
import net.minecraftforge.gradle.internal.ForgeGradleSharedData;
import net.minecraftforge.gradle.internal.MavenizerValueSource;
import net.minecraftforge.gradle.internal.MinecraftDependencyImpl;
import net.minecraftforge.gradle.internal.MinecraftDependencyInternal;
import net.minecraftforge.gradle.internal.MinecraftExtensionInternal;
import net.minecraftforge.gradle.internal.MinecraftMappingsImpl;
import net.minecraftforge.gradle.internal.MinecraftMappingsInternal;
import net.minecraftforge.gradle.internal.SlimeLauncherOptionsImpl;
import net.minecraftforge.gradle.internal.Tools;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.os.OS;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.flow.FlowProviders;
import org.gradle.api.flow.FlowScope;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

abstract class MinecraftExtensionImpl
implements MinecraftExtensionInternal {
    private static final String MAVENIZER_REPO_NAME = "MinecraftMavenizer";
    private final DirectoryProperty mavenizerOutput = this.getObjects().directoryProperty();
    private final Property<MinecraftMappingsInternal> mappings = this.getObjects().property(MinecraftMappingsInternal.class);
    private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);
    protected final ForgeGradlePlugin plugin;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    static void register(ForgeGradlePlugin plugin, ExtensionAware target) {
        ExtensionContainer extensions = target.getExtensions();
        if (target instanceof Project) {
            extensions.create(MinecraftExtensionForProject.class, "minecraft", ForProjectImpl.class, new Object[]{plugin});
        } else if (target instanceof Settings) {
            extensions.create(MinecraftExtension.class, "minecraft", ForSettingsImpl.class, new Object[]{plugin, target});
        } else {
            extensions.create(MinecraftExtension.class, "minecraft", MinecraftExtensionImpl.class, new Object[]{plugin});
        }
    }

    @Inject
    public MinecraftExtensionImpl(ForgeGradlePlugin plugin) {
        this.plugin = plugin;
        this.mavenizerOutput.convention(plugin.localCaches().dir("mavenizer/output").map(this.problems.ensureFileLocation()));
    }

    @Override
    public Property<MinecraftMappingsInternal> getMappingsProperty() {
        return this.mappings;
    }

    @Override
    public DirectoryProperty getMavenizerOutput() {
        return this.mavenizerOutput;
    }

    @Override
    public Action<MavenArtifactRepository> getMavenizer() {
        return maven -> {
            maven.setName(MAVENIZER_REPO_NAME);
            maven.setUrl((Object)this.getMavenizerOutput());
        };
    }

    @Override
    public MinecraftMappings getMappings() {
        try {
            return (MinecraftMappings)this.mappings.get();
        }
        catch (IllegalStateException e) {
            throw this.problems.missingMappings(e);
        }
    }

    @Override
    public void mappings(String channel, String version) {
        MinecraftMappingsImpl replacement = (MinecraftMappingsImpl)this.getObjects().newInstance(MinecraftMappingsImpl.class, new Object[]{channel, version});
        if (this.mappings.isPresent()) {
            this.problems.reportOverriddenMappings((MinecraftMappings)this.mappings.get(), replacement);
        }
        this.mappings.set((Object)replacement);
    }

    static void applyComponentRules(ComponentMetadataHandler components) {
        components.all(ForgeGradleComponentMetadataRules.AlwaysUseMatureStatus.class, ctor -> ctor.params(new Object[]{List.of("net.minecraftforge:forge", "net.minecraftforge:fmlonly")}));
    }

    static abstract class ForProjectImpl
    extends MinecraftExtensionImpl
    implements MinecraftExtensionInternal.ForProject {
        private final TaskProvider<Task> genEclipseRuns;
        final DirectoryProperty eclipseOutputDir = this.getObjects().directoryProperty().convention(this.getProjectLayout().getProjectDirectory().dir("bin"));
        private final NamedDomainObjectContainer<SlimeLauncherOptionsImpl> runs = this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class);
        private final List<MinecraftDependencyInternal> minecraftDependencies = new ArrayList<MinecraftDependencyInternal>();
        private final boolean hasAccessTransformersPlugin;
        private final ConfigurableFileCollection accessTransformer = this.getObjects().fileCollection();
        private final Property<String> accessTransformerPath = this.getObjects().property(String.class);
        private final ForgeGradleProblems problems = (ForgeGradleProblems)this.getObjects().newInstance(ForgeGradleProblems.class, new Object[0]);

        @Inject
        protected abstract Project getProject();

        @Inject
        protected abstract DependencyResolutionManagement getDependencyResolutionManagement();

        @Inject
        protected abstract FlowScope getFlowScope();

        @Inject
        protected abstract FlowProviders getFlowProviders();

        @Inject
        protected abstract ProjectLayout getProjectLayout();

        @Inject
        public ForProjectImpl(ForgeGradlePlugin plugin) {
            super(plugin);
            if (this.getProject().getPluginManager().hasPlugin("net.minecraftforge.accesstransformers")) {
                this.hasAccessTransformersPlugin = true;
            } else {
                this.hasAccessTransformersPlugin = false;
                this.getProject().getPluginManager().withPlugin("net.minecraftforge.accesstransformers", appliedPlugin -> {});
            }
            ForgeGradleSharedData sharedData = (ForgeGradleSharedData)this.getProject().getGradle().getExtensions().findByType(ForgeGradleSharedData.class);
            if (sharedData != null) {
                this.getMappingsProperty().value((Object)sharedData.mappings());
            }
            plugin.queueMessage(ForgeGradleMessage.WELCOME);
            plugin.queueMessage(ForgeGradleMessage.MAGIC);
            this.getFlowScope().always(ForgeGradleFlowAction.AccessTransformersMissing.class, spec -> spec.parameters(parameters -> {
                parameters.getFailure().set(this.getFlowProviders().getBuildWorkResult().map(p -> p.getFailure().orElse(null)));
                parameters.appliedPlugin.set((Object)this.hasAccessTransformersPlugin);
            }));
            this.getProject().getConfigurations().configureEach(c -> c.withDependencies(d -> this.apply((Configuration)c)));
            DependencyHandler dependencies = this.getProject().getDependencies();
            try {
                ForProjectImpl.applyComponentRules(dependencies.getComponents());
            }
            catch (Exception exception) {
                // empty catch block
            }
            AttributesSchema attributesSchema = dependencies.getAttributesSchema();
            attributesSchema.attribute(ForgeAttributes.OperatingSystem.ATTRIBUTE, strategy -> {
                OS currentOS = (OS)((Object)((Object)this.getProviders().of(ForgeAttributes.OperatingSystem.CurrentValue.class, ForgeAttributes.OperatingSystem.CurrentValue.Parameters.DEFAULT).get()));
                strategy.getDisambiguationRules().add(ForgeAttributes.OperatingSystem.DisambiguationRule.class, ctor -> ctor.params(new Object[]{currentOS}));
            });
            attributesSchema.attribute(ForgeAttributes.MappingsChannel.ATTRIBUTE, strategy -> strategy.getDisambiguationRules().add(ForgeAttributes.MappingsChannel.DisambiguationRule.class));
            attributesSchema.attribute(ForgeAttributes.MappingsVersion.ATTRIBUTE, strategy -> strategy.ordered(ForgeAttributes.MappingsVersion.COMPARATOR));
            this.genEclipseRuns = this.getProject().getTasks().register("genEclipseRuns", task -> {
                task.setGroup("IDE");
                task.setDescription("Generates the run configuration launch files for Eclipse.");
            });
            this.getProject().getPluginManager().withPlugin("eclipse", appliedPlugin -> this.getProject().getExtensions().configure(EclipseModel.class, eclipse -> {
                eclipse.synchronizationTasks(new Object[]{this.genEclipseRuns});
                this.eclipseOutputDir.fileProvider(this.getProviders().provider(() -> eclipse.getClasspath().getDefaultOutputDir()));
            }));
            this.getProject().afterEvaluate(this::finish);
        }

        @Override
        public boolean hasAccessTransformersPlugin() {
            return this.hasAccessTransformersPlugin;
        }

        @Override
        public ConfigurableFileCollection getAccessTransformer() {
            return this.accessTransformer;
        }

        @Override
        public Property<String> getAccessTransformerPath() {
            return this.accessTransformerPath;
        }

        @Override
        public List<? extends MavenArtifactRepository> getRepositories() {
            RepositoriesMode repositoriesMode = (RepositoriesMode)this.getDependencyResolutionManagement().getRepositoriesMode().getOrElse((Object)RepositoriesMode.PREFER_PROJECT);
            NamedDomainObjectList projectRepositories = this.getProject().getRepositories().withType(MavenArtifactRepository.class);
            NamedDomainObjectList settingsRepositories = this.getDependencyResolutionManagement().getRepositories().withType(MavenArtifactRepository.class);
            return switch (repositoriesMode) {
                default -> throw new IncompatibleClassChangeError();
                case RepositoriesMode.FAIL_ON_PROJECT_REPOS -> Collections.unmodifiableList(settingsRepositories);
                case RepositoriesMode.PREFER_SETTINGS -> Collections.unmodifiableList(!projectRepositories.isEmpty() && settingsRepositories.isEmpty() ? projectRepositories : settingsRepositories);
                case RepositoriesMode.PREFER_PROJECT -> Collections.unmodifiableList(!settingsRepositories.isEmpty() && projectRepositories.isEmpty() ? settingsRepositories : projectRepositories);
            };
        }

        @Override
        public DirectoryProperty getEclipseOutputDir() {
            return this.eclipseOutputDir;
        }

        private void apply(Configuration configuration) {
            if (!configuration.isCanBeResolved()) {
                return;
            }
            Set hierarchy = configuration.getHierarchy();
            Set minecraftDependencies = hierarchy.stream().flatMap(c -> c.getDependencies().matching(MinecraftDependencyInternal::is).stream()).map(MinecraftDependencyInternal::get).collect(Collectors.toSet());
            for (MinecraftDependencyInternal minecraftDependency : minecraftDependencies) {
                assert (minecraftDependency != null);
                minecraftDependency.handle(configuration);
            }
        }

        private void finish(Project project) {
            this.checkRepos(this.getRepositories());
            SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
            DirectoryProperty sourceSetsDir = this.getObjects().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir("sourceSets"));
            boolean mergeSourceSets = this.problems.test("net.minecraftforge.gradle.merge-source-sets");
            sourceSets.all(sourceSet -> {
                if (mergeSourceSets) {
                    Provider unifiedDir = sourceSetsDir.dir(sourceSet.getName());
                    sourceSet.getOutput().setResourcesDir((Object)unifiedDir);
                    sourceSet.getJava().getDestinationDirectory().set(unifiedDir);
                }
            });
            project.getPluginManager().withPlugin("eclipse", eclipsePlugin -> {
                if (mergeSourceSets) {
                    project.getExtensions().configure(EclipseModel.class, eclipse -> eclipse.getClasspath().setDefaultOutputDir((File)sourceSetsDir.getAsFile().get()));
                } else {
                    this.problems.reportUnmergedSourceSets();
                }
            });
            for (MinecraftDependencyInternal minecraftDependency : this.minecraftDependencies) {
                ExternalModuleDependency dependency = minecraftDependency.asDependency();
                if (dependency == null) continue;
                minecraftDependency.handle(Util.collect(project, false, (Dependency)dependency), Util.collect(project, true, (Dependency)dependency));
                project.getConfigurations().named(name -> name.startsWith("downloadArtifact_")).configureEach(configuration -> {
                    Iterator itor = configuration.getDependencies().iterator();
                    while (itor.hasNext()) {
                        Dependency existing = (Dependency)itor.next();
                        if (!Objects.equals(dependency.getGroup(), existing.getGroup()) || !dependency.getName().equals(existing.getName()) || !Objects.equals(dependency.getVersion(), existing.getVersion())) continue;
                        itor.remove();
                        ExternalModuleDependency replacement = dependency.copy();
                        replacement.attributes(a -> {
                            a.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)a.named(Category.class, "documentation")));
                            a.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)a.named(DocsType.class, "sources")));
                        });
                        configuration.withDependencies(dependencies -> dependencies.add((Object)replacement));
                    }
                });
            }
        }

        @Override
        public NamedDomainObjectContainer<? extends SlimeLauncherOptions> getRuns() {
            return this.runs;
        }

        @Override
        public Provider<ExternalModuleDependency> dependency(Object value, @DelegatesTo(value=ExternalModuleDependency.class) @ClosureParams(value=SimpleType.class, options={"net.minecraftforge.gradle.MinecraftDependency.ClosureOwner"}) Closure<?> closure) {
            if ((value = Util.unpack(value)) instanceof ExternalModuleDependencyBundle) {
                throw new IllegalArgumentException("Minecraft dependency cannot be a bundle");
            }
            MinecraftDependencyImpl minecraftDependency = (MinecraftDependencyImpl)this.getObjects().newInstance(MinecraftDependencyImpl.class, new Object[]{this.getMavenizerOutput()});
            this.minecraftDependencies.add(minecraftDependency);
            ExternalModuleDependency dep = minecraftDependency.init(value, closure);
            Provider mavenizer = this.getProviders().of(MavenizerValueSource.class, spec -> spec.parameters(params -> {
                Tool.Resolved tool = this.plugin.getTool(Tools.MAVENIZER);
                params.getClasspath().setFrom((Iterable)tool.getClasspath());
                params.getJavaLauncher().set(tool.getJavaLauncher().map(JavaLauncher::getExecutablePath));
                params.getArguments().set(this.getProviders().provider(() -> {
                    Provider toolCache = this.plugin.globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.problems.ensureFileLocation());
                    String cache = ((Directory)toolCache.get()).dir("caches").getAsFile().getAbsolutePath();
                    ArrayList<Object> ret = new ArrayList<Object>();
                    ret.addAll(List.of("--maven", "--cache", cache, "--jdk-cache", cache, "--output", ((Directory)this.getMavenizerOutput().get()).getAsFile().getAbsolutePath(), "--artifact", dep.getModule().toString(), "--version", Objects.requireNonNull(dep.getVersion()), "--global-auxiliary-variants"));
                    SourceSetContainer sourceSets = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
                    minecraftDependency.finalizeAccessTransformers((NamedDomainObjectSet<SourceSet>)sourceSets);
                    for (File at : minecraftDependency.getAccessTransformer()) {
                        ret.add("--access-transformer");
                        ret.add(at.getAbsolutePath());
                    }
                    MinecraftMappings mappings = minecraftDependency.getMappings();
                    if ("parchment".equals(mappings.getChannel())) {
                        ret.addAll(List.of("--parchment", mappings.getVersion()));
                    }
                    for (MavenArtifactRepository mavenArtifactRepository : this.getRepositories()) {
                        if (MinecraftExtensionImpl.MAVENIZER_REPO_NAME.equals(mavenArtifactRepository.getName())) continue;
                        Object url = mavenArtifactRepository.getUrl().toString();
                        if (!((String)url).endsWith("/")) {
                            url = (String)url + "/";
                        }
                        ret.add("--repository");
                        ret.add(mavenArtifactRepository.getName() + "," + (String)url);
                    }
                    return ret;
                }));
            }));
            return this.getProviders().provider(() -> {
                mavenizer.get();
                return dep;
            });
        }

        private void checkRepos(List<? extends MavenArtifactRepository> repos) {
            Predicate<String> contains = s -> {
                for (MavenArtifactRepository repo : repos) {
                    if (!repo.getUrl().toString().contains((CharSequence)s)) continue;
                    return true;
                }
                return false;
            };
            Predicate<Object> containsExactly = object -> {
                for (MavenArtifactRepository repo : repos) {
                    if (!repo.getUrl().equals(this.getProject().uri(object))) continue;
                    return true;
                }
                return false;
            };
            if (!containsExactly.test(this.getMavenizerOutput().getAsFile())) {
                this.problems.reportMcMavenNotDeclared();
            }
            if (!contains.test("maven.minecraftforge.net")) {
                this.problems.reportForgeMavenNotDeclared();
            }
            if (!contains.test("libraries.minecraft.net")) {
                this.problems.reportMcLibsMavenNotDeclared();
            }
        }
    }

    static abstract class ForSettingsImpl
    extends MinecraftExtensionImpl {
        @Inject
        public ForSettingsImpl(ForgeGradlePlugin plugin, Settings settings) {
            super(plugin);
            settings.getGradle().settingsEvaluated(this::finish);
        }

        private void finish(Settings settings) {
            settings.getGradle().getExtensions().add("__fg_shared_data", (Object)new ForgeGradleSharedData((MinecraftMappingsInternal)this.getMappingsProperty().getOrNull()));
            ForSettingsImpl.applyComponentRules(settings.getDependencyResolutionManagement().getComponents());
        }
    }
}

