/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.process.ExecOperations;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MavenizerValueSource
implements ValueSource<Boolean, Parameters> {
    private final ExecOperations execOps;
    private static final Logger logger = LoggerFactory.getLogger(MavenizerValueSource.class);

    @Inject
    public MavenizerValueSource(ExecOperations execOps) {
        this.execOps = execOps;
    }

    private void log(String line) {
        logger.info(line);
    }

    public @Nullable Boolean obtain() {
        this.execOps.javaexec(spec -> {
            Parameters params = (Parameters)this.getParameters();
            spec.setClasspath((FileCollection)params.getClasspath());
            spec.setExecutable(params.getJavaLauncher().get());
            spec.setArgs((List)params.getArguments().get());
            this.log("Executing Mavenizer: ");
            Iterator itr = params.getClasspath().iterator();
            this.log("  Classpath: " + ((File)itr.next()).getAbsolutePath());
            while (itr.hasNext()) {
                this.log("             " + ((File)itr.next()).getAbsolutePath());
            }
            this.log("  Java: " + ((RegularFile)params.getJavaLauncher().get()).getAsFile().getAbsolutePath());
            List args = (List)params.getArguments().get();
            String prefix = "  Arguments: ";
            for (int x = 0; x < args.size(); ++x) {
                String current = (String)args.get(x);
                String next = args.size() > x + 1 ? (String)args.get(x + 1) : null;
                Object line = current;
                if (current.startsWith("--") && next != null && !next.startsWith("--")) {
                    ++x;
                    line = (String)line + " " + next;
                }
                this.log(prefix + (String)line);
                prefix = "             ";
            }
        }).assertNormalExitValue();
        return false;
    }

    static interface Parameters
    extends ValueSourceParameters {
        public ConfigurableFileCollection getClasspath();

        public RegularFileProperty getJavaLauncher();

        public ListProperty<String> getArguments();
    }
}

