/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gradle.internal.Util;
import net.minecraftforge.gradle.shadow.net.minecraftforge.util.os.OS;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

final class ForgeAttributes {
    ForgeAttributes() {
    }

    static final class MappingsVersion {
        static final Attribute<String> ATTRIBUTE = Attribute.of((String)"net.minecraftforge.mappings.version", String.class);
        static final Comparator<String> COMPARATOR = Util.versionComparator();

        MappingsVersion() {
        }
    }

    static final class MappingsChannel {
        static final Attribute<String> ATTRIBUTE = Attribute.of((String)"net.minecraftforge.mappings.channel", String.class);

        MappingsChannel() {
        }

        static abstract class DisambiguationRule
        implements AttributeDisambiguationRule<String> {
            @Inject
            public DisambiguationRule() {
            }

            public void execute(MultipleCandidatesDetails<String> details) {
                Set options = details.getCandidateValues();
                if (options.contains("official")) {
                    details.closestMatch((Object)"official");
                } else if (options.contains("parchment")) {
                    details.closestMatch((Object)"parchment");
                }
            }
        }
    }

    static final class OperatingSystem {
        static final Attribute<String> ATTRIBUTE = Attribute.of((String)"net.minecraftforge.native.operatingSystem", String.class);

        OperatingSystem() {
        }

        static abstract class CurrentValue
        implements ValueSource<OS, Parameters> {
            @Inject
            public CurrentValue() {
            }

            public @Nullable OS obtain() {
                OS[] allowed = ((Set)((Parameters)this.getParameters()).getAllowedOperatingSystems().getOrElse(EnumSet.noneOf(OS.class))).toArray(new OS[0]);
                return allowed.length > 0 ? OS.current(allowed) : OS.current();
            }

            static interface Parameters
            extends ValueSourceParameters {
                public static final Action<? super ValueSourceSpec<Parameters>> DEFAULT = spec -> ((Parameters)spec.getParameters()).getAllowedOperatingSystems().set(Set.of(OS.WINDOWS, OS.MACOS, OS.LINUX));

                public SetProperty<OS> getAllowedOperatingSystems();
            }
        }

        static abstract class DisambiguationRule
        implements AttributeDisambiguationRule<String> {
            private final OS current;

            @Inject
            public DisambiguationRule(OS current) {
                this.current = current;
            }

            public void execute(MultipleCandidatesDetails<String> details) {
                List<OS> options = details.getCandidateValues().stream().map(OS::byKey).toList();
                if (options.contains((Object)this.current)) {
                    details.closestMatch((Object)this.current.key());
                    return;
                }
                for (OS os : options) {
                    String fallback = this.execute(this.current, os);
                    if (fallback == null) continue;
                    details.closestMatch((Object)fallback);
                    return;
                }
            }

            @NullUnmarked
            private String execute(OS current, OS os) {
                return current == os ? os.key() : (os != null ? this.execute(current, os.fallback()) : null);
            }
        }
    }
}

