/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.util.Locale;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;

enum ForgeGradleMessage {
    WELCOME("7_0_RC_WELCOME_1", "Welcome to ForgeGradle 7.0 Release Candidate!\n\nHere are some release highlights:\n- Complete rewrite of the plugin and underlying code.\n- Complete overhaul of DSL objects and registrations.\n- Slimmed down the plugin, which now delegates many actions to separate tools.\n- Support for declaring defaults in settings.gradle.\n- Support for all Forge versions from Minecraft 1.20.6 (older versions are a\n  work-in-progress).\n\nA couple of important things to note:\n- Many plugins that worked with ForgeGradle 6, such as Parchment's Librarian,\n  do not work with ForgeGradle 7. For most cases (such as parchment), we have\n  implemented native support. If ForgeGradle 7 is lacking in some aspect,\n  please let us know!\n- Many things that ForgeGradle 6 and older used to do are now decentralized\n  away from the plugin. This means that your project will need to apply\n  'net.minecraftforge.jarjar' if you wish to use Forge's Jar-in-Jar system.\n  If you are on an older version (1.20.4 and older), you will need the\n  'net.minecraftforge.renamer' plugin. Many of these come with our provided\n  MDK, so this should not be an issue for you.\n- If you come across any lingering bugs, please report them to our GitHub\n  issue tracker (https://github.com/MinecraftForge/ForgeGradle/issues).\n  Please do not use Discord as a means to report issues, as they will get\n  lost in the discussion very easily.\n\nFor more details on this release, see https://docs.minecraftforge.net/en/fg-7.0/", "This message will not display again until ForgeGradle 7.0 or the below file is\ndeleted:\n{}\n\nDocumentation will be coming at a later date. Thank you for testing\nForgeGradle 7!"),
    MAGIC("7_0_RC_MAGIC_1", "This build is using ForgeGradle Magic. ForgeGradle Magic employs automatic\nbehavior that is hidden from buildscript authors in order to implement and\naccount for convenience features.\n\nMagic is enabled by default. It can be disabled by using the following\nGradle property:\nnet.minecraftforge.gradle.magic=false\n\nFor more information, see https://docs.minecraftforge.net/en/fg-7.0/magic/");

    private static final String MESSAGES_DIR = "messages";
    private final String marker;
    private final String property;
    private final String text;
    private final String condition;

    private ForgeGradleMessage(String marker, String text) {
        this(marker, text, "This message will not display again unless the below file is deleted:\n{}");
    }

    private ForgeGradleMessage(String marker, String text, String condition) {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        this.marker = marker;
        this.property = "net.minecraftforge.gradle.messages." + name;
        this.text = text;
        this.condition = condition;
    }

    String getProperty() {
        return this.property;
    }

    String getText() {
        return this.text;
    }

    String getCondition() {
        return this.condition;
    }

    QueuedMessage queue(Project project, DirectoryProperty globalCaches) {
        return new QueuedMessage(project, globalCaches, this);
    }

    static Provider<Directory> getMessagesDirectory(DirectoryProperty globalCaches) {
        return globalCaches.dir(MESSAGES_DIR);
    }

    private Provider<RegularFile> getMarkerFile(DirectoryProperty globalCaches) {
        return ForgeGradleMessage.getMessagesDirectory(globalCaches).map(d -> d.file(this.marker));
    }

    private DisplayOption getDisplayOption(Project project) {
        return (DisplayOption)((Object)project.getProviders().gradleProperty(this.property).orElse(project.getProviders().systemProperty(this.property)).map(it -> DisplayOption.valueOf(it.toUpperCase(Locale.ROOT))).getOrElse((Object)DisplayOption.ONCE));
    }

    public record QueuedMessage(ForgeGradleMessage message, Provider<RegularFile> markerFile, DisplayOption displayOption) implements Comparable<QueuedMessage>
    {
        public QueuedMessage(Project project, DirectoryProperty globalCaches, ForgeGradleMessage message) {
            this(message, message.getMarkerFile(globalCaches), message.getDisplayOption(project));
        }

        @Override
        public int compareTo(QueuedMessage that) {
            return this.message.compareTo(that.message);
        }
    }

    static enum DisplayOption {
        ONCE,
        NEVER,
        ALWAYS;

    }
}

