/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.jetbrains.annotations.Nullable;

final class Util {
    Util() {
    }

    static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, int version) {
        return Util.launcherFor(java, javaToolchains, JavaLanguageVersion.of((int)version));
    }

    static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        JavaToolchainSpec currentToolchain = java.getToolchain();
        return ((JavaLanguageVersion)currentToolchain.getLanguageVersion().getOrElse((Object)JavaLanguageVersion.current())).canCompileOrRun(version) ? javaToolchains.launcherFor(currentToolchain) : Util.launcherForStrictly(javaToolchains, version);
    }

    static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, int version) {
        return Util.launcherForStrictly(javaToolchains, JavaLanguageVersion.of((int)version));
    }

    static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        return javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set((Object)version));
    }

    static String artifactPath(String group, String name, String version, @Nullable String classifier, String extension) {
        return MessageFormat.format("{0}/{1}/{2}/{1}-{2}{3}.{4}", group.replace('.', '/'), name, version, classifier == null ? "" : "-" + classifier, extension);
    }

    @Nullable
    static <T extends Collection<?>> T nullIfEmpty(@Nullable T c) {
        return c == null || c.isEmpty() ? null : (T)c;
    }

    @Nullable
    static <T extends Map<?, ?>> T nullIfEmpty(@Nullable T m) {
        return m == null || m.isEmpty() ? null : (T)m;
    }

    @Nullable
    static String nullIfEmpty(@Nullable String s) {
        return s == null || s.isBlank() ? null : s;
    }

    static boolean isTrue(Provider<? extends String> provider) {
        return (Boolean)provider.map(Boolean::parseBoolean).getOrElse((Object)false);
    }

    static <T> T tryElse(Callable<? extends T> value, T orElse) {
        try {
            return Objects.requireNonNull(value.call());
        }
        catch (Throwable e) {
            return orElse;
        }
    }

    static void runFirst(Project project, final TaskProvider<?> task) {
        ArrayList<1> requests = new ArrayList<1>(project.getGradle().getStartParameter().getTaskRequests());
        requests.add(0, new TaskExecutionRequest(){

            public List<String> getArgs() {
                return List.of(((Task)task.get()).getPath());
            }

            @Nullable
            public String getProjectPath() {
                return null;
            }

            @Nullable
            public File getRootDir() {
                return null;
            }
        });
        project.getLogger().info("Adding task to beginning of task graph! Project: {}, Task: {}", (Object)project.getName(), (Object)task.getName());
        project.getGradle().getStartParameter().setTaskRequests(requests);
    }
}

