/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import net.minecraftforge.gradle.MinecraftExtensionForProject;
import net.minecraftforge.gradle.MinecraftMappings;
import net.minecraftforge.gradle.internal.MinecraftExtensionInternal;
import net.minecraftforge.gradle.internal.ToolExec;
import net.minecraftforge.gradle.internal.Tools;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecResult;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Mavenizer uses its own in-house caching")
abstract class SyncMavenizer
extends ToolExec {
    static TaskProvider<SyncMavenizer> register(Project project, ExternalModuleDependency dependency, Provider<? extends MinecraftMappings> mappings, ConfigurableFileCollection accessTransformer, Provider<? extends Directory> output) {
        String version = dependency.getVersion();
        String taskName = "syncMavenizerFor" + StringGroovyMethods.capitalize((CharSequence)dependency.getName()) + (version == null ? "" : version.replace(".", "").replace('-', '_'));
        TaskContainer tasks = project.getTasks();
        return tasks.getNames().contains(taskName) ? tasks.named(taskName, SyncMavenizer.class) : tasks.register(taskName, SyncMavenizer.class, task -> {
            task.getOutput().set(output);
            task.getModule().set((Object)dependency.getModule());
            task.getVersion().set((Object)dependency.getVersion());
            task.getMappings().set(mappings);
            task.getAccessTransformer().setFrom((Iterable)accessTransformer);
        });
    }

    @Internal
    protected abstract DirectoryProperty getCaches();

    @Internal
    protected abstract DirectoryProperty getOutput();

    @Input
    protected abstract Property<ModuleIdentifier> getModule();

    @Input
    protected abstract Property<String> getVersion();

    @Input
    protected abstract Property<MinecraftMappings> getMappings();

    @InputFiles
    @Optional
    protected abstract ConfigurableFileCollection getAccessTransformer();

    @Input
    @Optional
    protected abstract ListProperty<String> getRepositories();

    private void addRepositories(Iterable<? extends MavenArtifactRepository> repositories) {
        for (MavenArtifactRepository mavenArtifactRepository : repositories) {
            if (mavenArtifactRepository.getName().equals("MinecraftMavenizer")) continue;
            Object s = mavenArtifactRepository.getUrl().toString();
            if (!((String)s).endsWith("/")) {
                s = (String)s + "/";
            }
            String url = s;
            this.getRepositories().add(this.getProviders().provider(() -> repository.getName() + "," + url));
        }
    }

    @Inject
    public SyncMavenizer() {
        super(Tools.MAVENIZER);
        this.getCaches().convention(this.defaultToolDir.dir("caches"));
        MinecraftExtensionInternal.ForProject minecraft = (MinecraftExtensionInternal.ForProject)this.getProject().getExtensions().getByType(MinecraftExtensionForProject.class);
        this.addRepositories(minecraft.getRepositories());
    }

    @Override
    protected ExecResult exec() throws IOException {
        return super.exec().rethrowFailure().assertNormalExitValue();
    }

    @Override
    protected void addArguments() {
        super.addArguments();
        this.args("--maven");
        this.args("--cache", (FileSystemLocationProperty<FileSystemLocation>)this.getCaches());
        this.args("--output", (FileSystemLocationProperty<FileSystemLocation>)this.getOutput());
        this.args("--jdk-cache", (FileSystemLocationProperty<FileSystemLocation>)this.getCaches());
        this.args("--artifact", (Provider<?>)this.getModule());
        this.args("--version", (Provider<?>)this.getVersion());
        this.args("--access-transformer", (Iterable<File>)this.getAccessTransformer());
        this.args("--global-auxiliary-variants");
        if ("parchment".equals(((MinecraftMappings)this.getMappings().get()).getChannel())) {
            this.args("--parchment", ((MinecraftMappings)this.getMappings().get()).getVersion());
        }
        for (String repository : (List)this.getRepositories().getOrElse(List.of())) {
            this.args("--repository", repository);
        }
    }
}

